/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean.producer;

import com.myjeeva.digitalocean.exception.DigitalOceanException;
import com.myjeeva.digitalocean.exception.RequestUnsuccessfulException;
import com.myjeeva.digitalocean.pojo.Delete;
import com.myjeeva.digitalocean.pojo.Key;
import com.myjeeva.digitalocean.pojo.Keys;
import org.apache.camel.Exchange;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.producer.DigitalOceanProducer;
import org.apache.camel.util.ObjectHelper;

public class DigitalOceanKeysProducer
extends DigitalOceanProducer {
    public DigitalOceanKeysProducer(DigitalOceanEndpoint endpoint, DigitalOceanConfiguration configuration) {
        super(endpoint, configuration);
    }

    @Override
    public void process(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        switch (this.determineOperation(exchange)) {
            case list: {
                this.getKeys(exchange);
                break;
            }
            case create: {
                this.createKey(exchange);
                break;
            }
            case get: {
                this.getKey(exchange);
                break;
            }
            case update: {
                this.updateKey(exchange);
                break;
            }
            case delete: {
                this.deleteKey(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void getKey(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Key key;
        Integer keyId = exchange.getIn().getHeader("CamelDigitalOceanId", Integer.class);
        String fingerprint = exchange.getIn().getHeader("CamelDigitalOceanKeyFingerprint", String.class);
        if (ObjectHelper.isNotEmpty(keyId)) {
            key = this.getEndpoint().getDigitalOceanClient().getKeyInfo(keyId);
        } else if (ObjectHelper.isNotEmpty(fingerprint)) {
            key = this.getEndpoint().getDigitalOceanClient().getKeyInfo(fingerprint);
        } else {
            throw new IllegalArgumentException("CamelDigitalOceanId or CamelDigitalOceanKeyFingerprint must be specified");
        }
        LOG.trace("Key [{}] ", (Object)key);
        exchange.getMessage().setBody(key);
    }

    private void getKeys(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Keys keys = this.getEndpoint().getDigitalOceanClient().getAvailableKeys(this.configuration.getPage());
        LOG.trace("All Keys : page {} [{}] ", (Object)this.configuration.getPage(), keys.getKeys());
        exchange.getMessage().setBody(keys.getKeys());
    }

    private void deleteKey(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Delete delete;
        Integer keyId = exchange.getIn().getHeader("CamelDigitalOceanId", Integer.class);
        String fingerprint = exchange.getIn().getHeader("CamelDigitalOceanKeyFingerprint", String.class);
        if (ObjectHelper.isNotEmpty(keyId)) {
            delete = this.getEndpoint().getDigitalOceanClient().deleteKey(keyId);
        } else if (ObjectHelper.isNotEmpty(fingerprint)) {
            delete = this.getEndpoint().getDigitalOceanClient().deleteKey(fingerprint);
        } else {
            throw new IllegalArgumentException("CamelDigitalOceanId or CamelDigitalOceanKeyFingerprint must be specified");
        }
        LOG.trace("Delete Key {}", (Object)delete);
        exchange.getMessage().setBody(delete);
    }

    private void createKey(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Key key = new Key();
        String name = exchange.getIn().getHeader("CamelDigitalOceanName", String.class);
        if (ObjectHelper.isEmpty(name)) {
            throw new IllegalArgumentException("CamelDigitalOceanName must be specified");
        }
        key.setName(name);
        String publicKey = exchange.getIn().getHeader("CamelDigitalOceanKeyPublicKey", String.class);
        if (ObjectHelper.isEmpty(publicKey)) {
            throw new IllegalArgumentException("CamelDigitalOceanKeyPublicKey must be specified");
        }
        key.setPublicKey(publicKey);
        key = this.getEndpoint().getDigitalOceanClient().createKey(key);
        LOG.trace("Key created {}", (Object)key);
        exchange.getMessage().setBody(key);
    }

    private void updateKey(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Key key;
        Integer keyId = exchange.getIn().getHeader("CamelDigitalOceanId", Integer.class);
        String fingerprint = exchange.getIn().getHeader("CamelDigitalOceanKeyFingerprint", String.class);
        String name = exchange.getIn().getHeader("CamelDigitalOceanName", String.class);
        if (ObjectHelper.isEmpty(name)) {
            throw new IllegalArgumentException("CamelDigitalOceanName must be specified");
        }
        if (ObjectHelper.isNotEmpty(keyId)) {
            key = this.getEndpoint().getDigitalOceanClient().updateKey(keyId, name);
        } else if (ObjectHelper.isNotEmpty(fingerprint)) {
            key = this.getEndpoint().getDigitalOceanClient().updateKey(fingerprint, name);
        } else {
            throw new IllegalArgumentException("CamelDigitalOceanId or CamelDigitalOceanKeyFingerprint must be specified");
        }
        LOG.trace("Update Key [{}] ", (Object)key);
        exchange.getMessage().setBody(key);
    }
}

