/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.disruptor;

import java.time.Duration;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.component.disruptor.DisruptorEndpoint;
import org.apache.camel.component.disruptor.DisruptorProducerType;
import org.apache.camel.component.disruptor.DisruptorWaitStrategy;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class DisruptorEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DisruptorEndpoint target = (DisruptorEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "blockwhenfull": 
            case "blockWhenFull": {
                target.setBlockWhenFull(DisruptorEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(DisruptorEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                target.setConcurrentConsumers(DisruptorEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(DisruptorEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(DisruptorEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(DisruptorEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "multipleconsumers": 
            case "multipleConsumers": {
                target.setMultipleConsumers(DisruptorEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "producertype": 
            case "producerType": {
                target.setProducerType(DisruptorEndpointConfigurer.property(camelContext, DisruptorProducerType.class, value));
                return true;
            }
            case "size": {
                target.setSize(DisruptorEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "timeout": {
                target.setTimeout(DisruptorEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "waitfortasktocomplete": 
            case "waitForTaskToComplete": {
                target.setWaitForTaskToComplete(DisruptorEndpointConfigurer.property(camelContext, WaitForTaskToComplete.class, value));
                return true;
            }
            case "waitstrategy": 
            case "waitStrategy": {
                target.setWaitStrategy(DisruptorEndpointConfigurer.property(camelContext, DisruptorWaitStrategy.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "blockwhenfull": 
            case "blockWhenFull": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                return Integer.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "multipleconsumers": 
            case "multipleConsumers": {
                return Boolean.TYPE;
            }
            case "producertype": 
            case "producerType": {
                return DisruptorProducerType.class;
            }
            case "size": {
                return Integer.TYPE;
            }
            case "timeout": {
                return Long.TYPE;
            }
            case "waitfortasktocomplete": 
            case "waitForTaskToComplete": {
                return WaitForTaskToComplete.class;
            }
            case "waitstrategy": 
            case "waitStrategy": {
                return DisruptorWaitStrategy.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DisruptorEndpoint target = (DisruptorEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "blockwhenfull": 
            case "blockWhenFull": {
                return target.isBlockWhenFull();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                return target.getConcurrentConsumers();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "multipleconsumers": 
            case "multipleConsumers": {
                return target.isMultipleConsumers();
            }
            case "producertype": 
            case "producerType": {
                return target.getProducerType();
            }
            case "size": {
                return target.getSize();
            }
            case "timeout": {
                return target.getTimeout();
            }
            case "waitfortasktocomplete": 
            case "waitForTaskToComplete": {
                return target.getWaitForTaskToComplete();
            }
            case "waitstrategy": 
            case "waitStrategy": {
                return target.getWaitStrategy();
            }
        }
        return null;
    }
}

