/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.camel.ApiEndpoint;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.PropertyConfigurerHelper;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.support.component.AbstractApiConfiguration;
import org.apache.camel.support.component.AbstractApiConsumer;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;
import org.apache.camel.support.component.PropertiesInterceptor;
import org.apache.camel.support.component.PropertyNamesInterceptor;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApiEndpoint<E extends ApiName, T>
extends ScheduledPollEndpoint
implements ApiEndpoint,
PropertyNamesInterceptor,
PropertiesInterceptor {
    private static final Map<String, ExecutorService> EXECUTOR_SERVICE_MAP = new ConcurrentHashMap<String, ExecutorService>();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final E apiName;
    protected final String methodName;
    protected final ApiMethodHelper<? extends ApiMethod> methodHelper;
    protected final T configuration;
    @UriParam(description="Sets the name of a parameter to be passed in the exchange In Body")
    protected String inBody;
    private List<ApiMethod> candidates;
    private volatile ExecutorService executorService;
    private Set<String> endpointPropertyNames;
    private Map<String, Object> endpointProperties;
    private Set<String> configurationPropertyNames;
    private Map<String, Object> configurationProperties;

    public AbstractApiEndpoint(String endpointUri, Component component, E apiName, String methodName, ApiMethodHelper<? extends ApiMethod> methodHelper, T endpointConfiguration) {
        super(endpointUri, component);
        this.apiName = apiName;
        this.methodName = methodName;
        this.methodHelper = methodHelper;
        this.configuration = endpointConfiguration;
    }

    protected abstract ApiMethodPropertiesHelper<T> getPropertiesHelper();

    @Override
    public void configureProperties(Map<String, Object> options) {
        if (options != null && !options.isEmpty()) {
            this.configureScheduledPollConsumerProperties(options);
            PropertyConfigurer configurer = this.getComponent().getEndpointPropertyConfigurer();
            PropertyConfigurer configurer2 = PropertyConfigurerHelper.resolvePropertyConfigurer(this.getCamelContext(), this.getConfiguration());
            PropertyBindingSupport.build().withConfigurer(configurer).withIgnoreCase(true).withReflection(false).bind(this.getCamelContext(), this, options);
            PropertyBindingSupport.build().withConfigurer(configurer2).withIgnoreCase(true).withReflection(false).bind(this.getCamelContext(), this.getConfiguration(), options);
            if (!options.isEmpty()) {
                PropertyBindingSupport.build().withConfigurer(configurer).withIgnoreCase(true).withReflection(true).bind(this.getCamelContext(), this, options);
                PropertyBindingSupport.build().withConfigurer(configurer2).withIgnoreCase(true).withReflection(true).bind(this.getCamelContext(), this.getConfiguration(), options);
            }
        }
        this.initState();
        this.afterConfigureProperties();
    }

    protected abstract void afterConfigureProperties();

    private void initState() {
        Set<String> missing;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.getPropertiesHelper().getConfigurationProperties(this.getCamelContext(), this.configuration, properties);
        this.configurationProperties = Collections.unmodifiableMap(properties);
        this.configurationPropertyNames = Collections.unmodifiableSet(properties.keySet());
        properties = new HashMap();
        this.getPropertiesHelper().getEndpointProperties(this.getCamelContext(), this.configuration, properties);
        this.endpointProperties = Collections.unmodifiableMap(properties);
        this.endpointPropertyNames = Collections.unmodifiableSet(properties.keySet());
        HashSet<String> arguments = new HashSet<String>(this.endpointPropertyNames);
        if (this.inBody != null) {
            arguments.add(this.inBody);
        }
        this.interceptPropertyNames(arguments);
        this.candidates = new ArrayList<ApiMethod>();
        this.candidates.addAll(this.methodHelper.getCandidateMethods(this.methodName, arguments));
        this.candidates = Collections.unmodifiableList(this.candidates);
        if (this.candidates.isEmpty()) {
            throw new IllegalArgumentException(String.format("No matching method for %s/%s, with arguments %s", this.apiName.getName(), this.methodName, arguments));
        }
        if (this.log.isDebugEnabled() && !(missing = this.methodHelper.getMissingProperties(this.methodName, arguments)).isEmpty()) {
            this.log.debug("Method {} could use one or more properties from {}", (Object)this.methodName, missing);
        }
    }

    @Override
    protected void configureConsumer(Consumer consumer) throws Exception {
        super.configureConsumer(consumer);
        if (this.getConfiguration() instanceof AbstractApiConfiguration && consumer instanceof AbstractApiConsumer) {
            ((AbstractApiConsumer)consumer).setSplitResult(((AbstractApiConfiguration)this.getConfiguration()).isSplitResult());
        }
    }

    @Override
    public void interceptPropertyNames(Set<String> propertyNames) {
    }

    @Override
    public void interceptProperties(Map<String, Object> properties) {
    }

    public final T getConfiguration() {
        return this.configuration;
    }

    public final E getApiName() {
        return this.apiName;
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final ApiMethodHelper<? extends ApiMethod> getMethodHelper() {
        return this.methodHelper;
    }

    public final List<ApiMethod> getCandidates() {
        return this.candidates;
    }

    public final String getInBody() {
        return this.inBody;
    }

    public final void setInBody(String inBody) throws IllegalArgumentException {
        ObjectHelper.notNull(inBody, "inBody");
        if (!this.getPropertiesHelper().getValidEndpointProperties(this.getCamelContext(), this.getConfiguration()).contains(inBody)) {
            throw new IllegalArgumentException("Unknown property " + inBody);
        }
        this.inBody = inBody;
    }

    public final Set<String> getEndpointPropertyNames() {
        return this.endpointPropertyNames;
    }

    public final Map<String, Object> getEndpointProperties() {
        return this.endpointProperties;
    }

    public Set<String> getConfigurationPropertyNames() {
        return this.configurationPropertyNames;
    }

    public final Map<String, Object> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public abstract Object getApiProxy(ApiMethod var1, Map<String, Object> var2);

    private static ExecutorService getExecutorService(Class<? extends AbstractApiEndpoint> endpointClass, CamelContext context, String threadProfileName) {
        String endpointClassName = endpointClass.getName();
        ExecutorService executorService = EXECUTOR_SERVICE_MAP.get(endpointClassName);
        if (executorService == null || executorService.isTerminated() || executorService.isShutdown()) {
            ExecutorServiceManager manager = context.getExecutorServiceManager();
            ThreadPoolProfile poolProfile = manager.getThreadPoolProfile(threadProfileName);
            if (poolProfile == null) {
                poolProfile = manager.getDefaultThreadPoolProfile();
            }
            executorService = manager.newScheduledThreadPool(endpointClass, threadProfileName, poolProfile);
            EXECUTOR_SERVICE_MAP.put(endpointClassName, executorService);
        }
        return executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExecutorService getExecutorService() {
        if (this.executorService == null) {
            AbstractApiEndpoint abstractApiEndpoint = this;
            synchronized (abstractApiEndpoint) {
                if (this.executorService == null) {
                    this.executorService = AbstractApiEndpoint.getExecutorService(this.getClass(), this.getCamelContext(), this.getThreadProfileName());
                }
            }
        }
        return this.executorService;
    }

    protected abstract String getThreadProfileName();
}

