/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.disruptor;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.disruptor.SynchronizedExchange;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.UnitOfWorkHelper;

public abstract class AbstractSynchronizedExchange
implements SynchronizedExchange {
    protected final List<Synchronization> synchronizations;
    private final Exchange exchange;

    protected AbstractSynchronizedExchange(Exchange exchange) {
        this.exchange = exchange;
        this.synchronizations = exchange.getExchangeExtension().handoverCompletions();
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public Exchange cancelAndGetOriginalExchange() {
        if (this.synchronizations != null) {
            for (Synchronization synchronization : this.synchronizations) {
                this.exchange.getExchangeExtension().addOnCompletion(synchronization);
            }
        }
        return this.exchange;
    }

    protected void performSynchronization() {
        UnitOfWorkHelper.doneSynchronizations(this.getExchange(), this.synchronizations);
    }
}

