/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.disruptor;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.disruptor.DisruptorEndpoint;
import org.apache.camel.component.disruptor.DisruptorProducerType;
import org.apache.camel.component.disruptor.DisruptorReference;
import org.apache.camel.component.disruptor.DisruptorWaitStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="disruptor")
public class DisruptorComponent
extends DefaultComponent {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int MAX_CONCURRENT_CONSUMERS = 500;
    private static final Logger LOGGER = LoggerFactory.getLogger(DisruptorComponent.class);
    @Metadata(defaultValue="1024")
    private int bufferSize = -1;
    @Metadata(label="consumer", defaultValue="1")
    private int defaultConcurrentConsumers = 1;
    @Metadata(label="consumer")
    private boolean defaultMultipleConsumers;
    @Metadata(label="producer", defaultValue="Multi")
    private DisruptorProducerType defaultProducerType = DisruptorProducerType.Multi;
    @Metadata(label="consumer", defaultValue="Blocking")
    private DisruptorWaitStrategy defaultWaitStrategy = DisruptorWaitStrategy.Blocking;
    @Metadata(label="producer", defaultValue="true")
    private boolean defaultBlockWhenFull = true;
    private final Map<String, DisruptorReference> disruptors = new HashMap<String, DisruptorReference>();

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        int concurrentConsumers = this.getAndRemoveParameter(parameters, "concurrentConsumers", Integer.class, this.defaultConcurrentConsumers);
        boolean limitConcurrentConsumers = this.getAndRemoveParameter(parameters, "limitConcurrentConsumers", Boolean.class, true);
        if (limitConcurrentConsumers && concurrentConsumers > 500) {
            throw new IllegalArgumentException("The limitConcurrentConsumers flag in set to true. ConcurrentConsumers cannot be set at a value greater than 500 was " + concurrentConsumers);
        }
        if (concurrentConsumers < 0) {
            throw new IllegalArgumentException("concurrentConsumers found to be " + concurrentConsumers + ", must be greater than 0");
        }
        int size = 0;
        if (parameters.containsKey("size") && (size = this.getAndRemoveParameter(parameters, "size", Integer.TYPE).intValue()) <= 0) {
            throw new IllegalArgumentException("size found to be " + size + ", must be greater than 0");
        }
        if (parameters.containsKey("pollTimeout")) {
            throw new IllegalArgumentException("The 'pollTimeout' argument is not supported by the Disruptor component");
        }
        DisruptorWaitStrategy waitStrategy = this.getAndRemoveParameter(parameters, "waitStrategy", DisruptorWaitStrategy.class, this.defaultWaitStrategy);
        DisruptorProducerType producerType = this.getAndRemoveParameter(parameters, "producerType", DisruptorProducerType.class, this.defaultProducerType);
        boolean multipleConsumers = this.getAndRemoveParameter(parameters, "multipleConsumers", Boolean.TYPE, this.defaultMultipleConsumers);
        boolean blockWhenFull = this.getAndRemoveParameter(parameters, "blockWhenFull", Boolean.TYPE, this.defaultBlockWhenFull);
        DisruptorReference disruptorReference = this.getOrCreateDisruptor(uri, remaining, size, producerType, waitStrategy);
        DisruptorEndpoint answer = new DisruptorEndpoint(uri, this, disruptorReference);
        answer.setConcurrentConsumers(concurrentConsumers);
        answer.setMultipleConsumers(multipleConsumers);
        answer.setBlockWhenFull(blockWhenFull);
        answer.setWaitStrategy(waitStrategy);
        answer.setProducerType(producerType);
        this.setProperties(answer, parameters);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DisruptorReference getOrCreateDisruptor(String uri, String name, int size, DisruptorProducerType producerType, DisruptorWaitStrategy waitStrategy) throws Exception {
        String key = DisruptorComponent.getDisruptorKey(uri);
        int sizeToUse = size > 0 ? size : (this.bufferSize > 0 ? this.bufferSize : 1024);
        sizeToUse = DisruptorComponent.powerOfTwo(sizeToUse);
        this.lock.lock();
        try {
            DisruptorReference ref = this.getDisruptors().get(key);
            if (ref == null) {
                LOGGER.debug("Creating new disruptor for key {}", (Object)key);
                ref = new DisruptorReference(this, uri, name, sizeToUse, producerType, waitStrategy);
                this.getDisruptors().put(key, ref);
            } else {
                if (size != 0 && ref.getBufferSize() != sizeToUse) {
                    throw new IllegalArgumentException("Cannot use existing queue " + key + " as the existing queue size " + ref.getBufferSize() + " does not match given queue size " + sizeToUse);
                }
                LOGGER.debug("Reusing disruptor {} for key {}", (Object)ref, (Object)key);
            }
            DisruptorReference disruptorReference = ref;
            return disruptorReference;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static int powerOfTwo(int size) {
        --size;
        size |= size >> 1;
        size |= size >> 2;
        size |= size >> 4;
        size |= size >> 8;
        size |= size >> 16;
        return ++size;
    }

    public static String getDisruptorKey(String uri) {
        return StringHelper.before(uri, "?", uri);
    }

    @Override
    protected void doStop() throws Exception {
        this.lock.lock();
        try {
            this.getDisruptors().clear();
        }
        finally {
            this.lock.unlock();
        }
        super.doStop();
    }

    public Map<String, DisruptorReference> getDisruptors() {
        return this.disruptors;
    }

    public int getDefaultConcurrentConsumers() {
        return this.defaultConcurrentConsumers;
    }

    public void setDefaultConcurrentConsumers(int defaultConcurrentConsumers) {
        this.defaultConcurrentConsumers = defaultConcurrentConsumers;
    }

    public boolean isDefaultMultipleConsumers() {
        return this.defaultMultipleConsumers;
    }

    public void setDefaultMultipleConsumers(boolean defaultMultipleConsumers) {
        this.defaultMultipleConsumers = defaultMultipleConsumers;
    }

    public DisruptorProducerType getDefaultProducerType() {
        return this.defaultProducerType;
    }

    public void setDefaultProducerType(DisruptorProducerType defaultProducerType) {
        this.defaultProducerType = defaultProducerType;
    }

    public DisruptorWaitStrategy getDefaultWaitStrategy() {
        return this.defaultWaitStrategy;
    }

    public void setDefaultWaitStrategy(DisruptorWaitStrategy defaultWaitStrategy) {
        this.defaultWaitStrategy = defaultWaitStrategy;
    }

    public boolean isDefaultBlockWhenFull() {
        return this.defaultBlockWhenFull;
    }

    public void setDefaultBlockWhenFull(boolean defaultBlockWhenFull) {
        this.defaultBlockWhenFull = defaultBlockWhenFull;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void onShutdownEndpoint(DisruptorEndpoint disruptorEndpoint) {
        String disruptorKey = DisruptorComponent.getDisruptorKey(disruptorEndpoint.getEndpointUri());
        DisruptorReference disruptorReference = this.getDisruptors().get(disruptorKey);
        if (disruptorReference.getEndpointCount() == 0) {
            this.getDisruptors().remove(disruptorKey);
        }
    }
}

