/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns;

import java.net.InetAddress;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.StringHelper;

public class DnsIpProducer
extends DefaultProducer {
    public DnsIpProducer(Endpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String domain = exchange.getIn().getHeader("dns.domain", String.class);
        StringHelper.notEmpty(domain, "Header dns.domain");
        InetAddress address = InetAddress.getByName(domain);
        exchange.getIn().setBody(address);
    }
}

