/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns;

import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.StringHelper;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Type;

public class DnsLookupProducer
extends DefaultProducer {
    public DnsLookupProducer(Endpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String dnsName = exchange.getIn().getHeader("dns.name", String.class);
        StringHelper.notEmpty(dnsName, "Header dns.name");
        Object type = exchange.getIn().getHeader("dns.type");
        Integer dnsType = null;
        if (type != null) {
            dnsType = Type.value(String.valueOf(type));
        }
        Object dclass = exchange.getIn().getHeader("dns.class");
        Integer dnsClass = null;
        if (dclass != null) {
            dnsClass = DClass.value(String.valueOf(dclass));
        }
        Lookup lookup2 = dnsClass == null ? (dnsType == null ? new Lookup(dnsName) : new Lookup(dnsName, (int)dnsType)) : new Lookup(dnsName, (int)dnsType, (int)dnsClass);
        lookup2.run();
        if (lookup2.getAnswers() == null) {
            throw new CamelException(lookup2.getErrorString());
        }
        exchange.getIn().setBody(lookup2.getAnswers());
    }
}

