/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns.types;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Converter;
import org.xbill.DNS.Address;
import org.xbill.DNS.Message;
import org.xbill.DNS.Record;

@Converter(generateLoader=true)
public final class DnsConverter {
    private DnsConverter() {
    }

    @Converter
    public static String toString(Record record) {
        return record.toString();
    }

    @Converter
    public static List<String> toList(Record[] records) {
        ArrayList<String> list = new ArrayList<String>();
        for (Record rec : records) {
            list.add(DnsConverter.toString(rec));
        }
        return list;
    }

    @Converter
    public static String toString(Message message) {
        return message.toString();
    }

    @Converter
    public static String toString(Address address) {
        return address.toString();
    }

    @Converter
    public static String toString(InetAddress address) {
        return address.getHostAddress();
    }

    @Converter
    public static InetAddress toInetAddress(String domain) throws UnknownHostException {
        return Address.getByName(domain);
    }
}

