/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.netty.ChannelProvider;
import com.github.dockerjava.netty.NettyInvocationBuilder;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.netty.handler.codec.http.HttpConstants;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class NettyWebTarget
implements WebTarget {
    private final ChannelProvider channelProvider;
    private final String host;
    private final ImmutableList<String> path;
    private final ImmutableMap<String, String> queryParams;
    private final ImmutableMap<String, Set<String>> queryParamsSet;
    private static final String PATH_SEPARATOR = "/";
    private final ObjectMapper objectMapper;

    @Deprecated
    public NettyWebTarget(ChannelProvider channelProvider, String host) {
        this(DockerClientConfig.getDefaultObjectMapper(), channelProvider, host, ImmutableList.of(), ImmutableMap.of(), ImmutableMap.of());
    }

    public NettyWebTarget(ObjectMapper objectMapper, ChannelProvider channelProvider, String host) {
        this(objectMapper, channelProvider, host, ImmutableList.of(), ImmutableMap.of(), ImmutableMap.of());
    }

    private NettyWebTarget(ObjectMapper objectMapper, ChannelProvider channelProvider, String host, ImmutableList<String> path, ImmutableMap<String, String> queryParams, ImmutableMap<String, Set<String>> queryParamsSet) {
        this.objectMapper = objectMapper;
        this.channelProvider = channelProvider;
        this.host = host;
        this.path = path;
        this.queryParams = queryParams;
        this.queryParamsSet = queryParamsSet;
    }

    @Override
    public NettyWebTarget path(String ... components) {
        ImmutableCollection.Builder newPath = ImmutableList.builder().addAll(this.path);
        for (String component : components) {
            ((ImmutableList.Builder)newPath).addAll(Arrays.asList(StringUtils.split(component, PATH_SEPARATOR)));
        }
        return new NettyWebTarget(this.objectMapper, this.channelProvider, this.host, (ImmutableList<String>)((ImmutableList.Builder)newPath).build(), this.queryParams, this.queryParamsSet);
    }

    @Override
    public NettyInvocationBuilder request() {
        String resource = PATH_SEPARATOR + StringUtils.join(this.path, PATH_SEPARATOR);
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry entry : this.queryParams.entrySet()) {
            params.add((String)entry.getKey() + "=" + NettyWebTarget.encodeComponent((String)entry.getValue(), HttpConstants.DEFAULT_CHARSET));
        }
        for (Map.Entry entry : this.queryParamsSet.entrySet()) {
            for (String entryValueValue : (Set)entry.getValue()) {
                params.add((String)entry.getKey() + "=" + NettyWebTarget.encodeComponent(entryValueValue, HttpConstants.DEFAULT_CHARSET));
            }
        }
        if (!params.isEmpty()) {
            resource = resource + "?" + StringUtils.join(params, "&");
        }
        return new NettyInvocationBuilder(this.objectMapper, this.channelProvider, resource).header("Host", this.host);
    }

    private static String encodeComponent(String s2, Charset charset) {
        try {
            return URLEncoder.encode(s2, charset.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException ignored) {
            throw new UnsupportedCharsetException(charset.name());
        }
    }

    @Override
    public NettyWebTarget resolveTemplate(String name, Object value) {
        ImmutableList.Builder newPath = ImmutableList.builder();
        for (String component : this.path) {
            component = component.replaceAll("\\{" + name + "\\}", value.toString());
            newPath.add(component);
        }
        return new NettyWebTarget(this.objectMapper, this.channelProvider, this.host, (ImmutableList<String>)newPath.build(), this.queryParams, this.queryParamsSet);
    }

    @Override
    public NettyWebTarget queryParam(String name, Object value) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder().putAll(this.queryParams);
        if (value != null) {
            builder.put(name, value.toString());
        }
        return new NettyWebTarget(this.objectMapper, this.channelProvider, this.host, this.path, builder.build(), this.queryParamsSet);
    }

    @Override
    public NettyWebTarget queryParamsSet(String name, Set<?> values) {
        ImmutableMap.Builder<String, Set<String>> builder = ImmutableMap.builder().putAll(this.queryParamsSet);
        if (values != null) {
            ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
            for (Object value : values) {
                valueBuilder.add(value.toString());
            }
            builder.put(name, (Set<String>)((Object)valueBuilder.build()));
        }
        return new NettyWebTarget(this.objectMapper, this.channelProvider, this.host, this.path, this.queryParams, builder.build());
    }

    @Override
    public NettyWebTarget queryParamsJsonMap(String name, Map<String, String> values) {
        if (values != null && !values.isEmpty()) {
            try {
                return this.queryParam(name, this.objectMapper.writeValueAsString(values));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NettyWebTarget webTarget = (NettyWebTarget)o;
        if (!Objects.equals(this.channelProvider, webTarget.channelProvider)) {
            return false;
        }
        if (!Objects.equals(this.path, webTarget.path)) {
            return false;
        }
        if (!Objects.equals(this.queryParams, webTarget.queryParams)) {
            return false;
        }
        return Objects.equals(this.queryParamsSet, webTarget.queryParamsSet);
    }

    public int hashCode() {
        int result = this.channelProvider != null ? this.channelProvider.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.queryParams != null ? this.queryParams.hashCode() : 0);
        result = 31 * result + (this.queryParamsSet != null ? this.queryParamsSet.hashCode() : 0);
        return result;
    }
}

