/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.teamlog.NonTeamMemberLogInfo;
import com.dropbox.core.v2.teamlog.TeamLogInfo;
import com.dropbox.core.v2.teamlog.TeamMemberLogInfo;
import com.dropbox.core.v2.teamlog.TrustedNonTeamMemberLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ContextLogInfo {
    public static final ContextLogInfo ANONYMOUS = new ContextLogInfo().withTag(Tag.ANONYMOUS);
    public static final ContextLogInfo TEAM = new ContextLogInfo().withTag(Tag.TEAM);
    public static final ContextLogInfo OTHER = new ContextLogInfo().withTag(Tag.OTHER);
    private Tag _tag;
    private NonTeamMemberLogInfo nonTeamMemberValue;
    private TeamLogInfo organizationTeamValue;
    private TeamMemberLogInfo teamMemberValue;
    private TrustedNonTeamMemberLogInfo trustedNonTeamMemberValue;

    private ContextLogInfo() {
    }

    private ContextLogInfo withTag(Tag _tag) {
        ContextLogInfo result = new ContextLogInfo();
        result._tag = _tag;
        return result;
    }

    private ContextLogInfo withTagAndNonTeamMember(Tag _tag, NonTeamMemberLogInfo nonTeamMemberValue) {
        ContextLogInfo result = new ContextLogInfo();
        result._tag = _tag;
        result.nonTeamMemberValue = nonTeamMemberValue;
        return result;
    }

    private ContextLogInfo withTagAndOrganizationTeam(Tag _tag, TeamLogInfo organizationTeamValue) {
        ContextLogInfo result = new ContextLogInfo();
        result._tag = _tag;
        result.organizationTeamValue = organizationTeamValue;
        return result;
    }

    private ContextLogInfo withTagAndTeamMember(Tag _tag, TeamMemberLogInfo teamMemberValue) {
        ContextLogInfo result = new ContextLogInfo();
        result._tag = _tag;
        result.teamMemberValue = teamMemberValue;
        return result;
    }

    private ContextLogInfo withTagAndTrustedNonTeamMember(Tag _tag, TrustedNonTeamMemberLogInfo trustedNonTeamMemberValue) {
        ContextLogInfo result = new ContextLogInfo();
        result._tag = _tag;
        result.trustedNonTeamMemberValue = trustedNonTeamMemberValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAnonymous() {
        return this._tag == Tag.ANONYMOUS;
    }

    public boolean isNonTeamMember() {
        return this._tag == Tag.NON_TEAM_MEMBER;
    }

    public static ContextLogInfo nonTeamMember(NonTeamMemberLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ContextLogInfo().withTagAndNonTeamMember(Tag.NON_TEAM_MEMBER, value);
    }

    public NonTeamMemberLogInfo getNonTeamMemberValue() {
        if (this._tag != Tag.NON_TEAM_MEMBER) {
            throw new IllegalStateException("Invalid tag: required Tag.NON_TEAM_MEMBER, but was Tag." + this._tag.name());
        }
        return this.nonTeamMemberValue;
    }

    public boolean isOrganizationTeam() {
        return this._tag == Tag.ORGANIZATION_TEAM;
    }

    public static ContextLogInfo organizationTeam(TeamLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ContextLogInfo().withTagAndOrganizationTeam(Tag.ORGANIZATION_TEAM, value);
    }

    public TeamLogInfo getOrganizationTeamValue() {
        if (this._tag != Tag.ORGANIZATION_TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.ORGANIZATION_TEAM, but was Tag." + this._tag.name());
        }
        return this.organizationTeamValue;
    }

    public boolean isTeam() {
        return this._tag == Tag.TEAM;
    }

    public boolean isTeamMember() {
        return this._tag == Tag.TEAM_MEMBER;
    }

    public static ContextLogInfo teamMember(TeamMemberLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ContextLogInfo().withTagAndTeamMember(Tag.TEAM_MEMBER, value);
    }

    public TeamMemberLogInfo getTeamMemberValue() {
        if (this._tag != Tag.TEAM_MEMBER) {
            throw new IllegalStateException("Invalid tag: required Tag.TEAM_MEMBER, but was Tag." + this._tag.name());
        }
        return this.teamMemberValue;
    }

    public boolean isTrustedNonTeamMember() {
        return this._tag == Tag.TRUSTED_NON_TEAM_MEMBER;
    }

    public static ContextLogInfo trustedNonTeamMember(TrustedNonTeamMemberLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ContextLogInfo().withTagAndTrustedNonTeamMember(Tag.TRUSTED_NON_TEAM_MEMBER, value);
    }

    public TrustedNonTeamMemberLogInfo getTrustedNonTeamMemberValue() {
        if (this._tag != Tag.TRUSTED_NON_TEAM_MEMBER) {
            throw new IllegalStateException("Invalid tag: required Tag.TRUSTED_NON_TEAM_MEMBER, but was Tag." + this._tag.name());
        }
        return this.trustedNonTeamMemberValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.nonTeamMemberValue, this.organizationTeamValue, this.teamMemberValue, this.trustedNonTeamMemberValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ContextLogInfo) {
            ContextLogInfo other = (ContextLogInfo)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ANONYMOUS: {
                    return true;
                }
                case NON_TEAM_MEMBER: {
                    return this.nonTeamMemberValue == other.nonTeamMemberValue || this.nonTeamMemberValue.equals(other.nonTeamMemberValue);
                }
                case ORGANIZATION_TEAM: {
                    return this.organizationTeamValue == other.organizationTeamValue || this.organizationTeamValue.equals(other.organizationTeamValue);
                }
                case TEAM: {
                    return true;
                }
                case TEAM_MEMBER: {
                    return this.teamMemberValue == other.teamMemberValue || this.teamMemberValue.equals(other.teamMemberValue);
                }
                case TRUSTED_NON_TEAM_MEMBER: {
                    return this.trustedNonTeamMemberValue == other.trustedNonTeamMemberValue || this.trustedNonTeamMemberValue.equals(other.trustedNonTeamMemberValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ContextLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ContextLogInfo value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ANONYMOUS: {
                    g.writeString("anonymous");
                    break;
                }
                case NON_TEAM_MEMBER: {
                    g.writeStartObject();
                    this.writeTag("non_team_member", g);
                    NonTeamMemberLogInfo.Serializer.INSTANCE.serialize(value.nonTeamMemberValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case ORGANIZATION_TEAM: {
                    g.writeStartObject();
                    this.writeTag("organization_team", g);
                    TeamLogInfo.Serializer.INSTANCE.serialize(value.organizationTeamValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case TEAM: {
                    g.writeString("team");
                    break;
                }
                case TEAM_MEMBER: {
                    g.writeStartObject();
                    this.writeTag("team_member", g);
                    TeamMemberLogInfo.Serializer.INSTANCE.serialize(value.teamMemberValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case TRUSTED_NON_TEAM_MEMBER: {
                    g.writeStartObject();
                    this.writeTag("trusted_non_team_member", g);
                    TrustedNonTeamMemberLogInfo.Serializer.INSTANCE.serialize(value.trustedNonTeamMemberValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public ContextLogInfo deserialize(JsonParser p) throws IOException, JsonParseException {
            ContextLogInfo value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("anonymous".equals(tag)) {
                value = ANONYMOUS;
            } else if ("non_team_member".equals(tag)) {
                NonTeamMemberLogInfo fieldValue = null;
                fieldValue = NonTeamMemberLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = ContextLogInfo.nonTeamMember(fieldValue);
            } else if ("organization_team".equals(tag)) {
                TeamLogInfo fieldValue = null;
                fieldValue = TeamLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = ContextLogInfo.organizationTeam(fieldValue);
            } else if ("team".equals(tag)) {
                value = TEAM;
            } else if ("team_member".equals(tag)) {
                TeamMemberLogInfo fieldValue = null;
                fieldValue = TeamMemberLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = ContextLogInfo.teamMember(fieldValue);
            } else if ("trusted_non_team_member".equals(tag)) {
                TrustedNonTeamMemberLogInfo fieldValue = null;
                fieldValue = TrustedNonTeamMemberLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = ContextLogInfo.trustedNonTeamMember(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ANONYMOUS,
        NON_TEAM_MEMBER,
        ORGANIZATION_TEAM,
        TEAM,
        TEAM_MEMBER,
        TRUSTED_NON_TEAM_MEMBER,
        OTHER;

    }
}

