/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class DropboxEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":operation";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    @Override
    public boolean isEnabled(String scheme) {
        return "dropbox".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "operation", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(17);
        props.add("accessToken");
        props.add("apiKey");
        props.add("apiSecret");
        props.add("bridgeErrorHandler");
        props.add("client");
        props.add("clientIdentifier");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("expireIn");
        props.add("lazyStartProducer");
        props.add("localPath");
        props.add("newRemotePath");
        props.add("operation");
        props.add("query");
        props.add("refreshToken");
        props.add("remotePath");
        props.add("uploadMode");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(5);
        secretProps.add("accessToken");
        secretProps.add("apiKey");
        secretProps.add("apiSecret");
        secretProps.add("expireIn");
        secretProps.add("refreshToken");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

