/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.consumer;

import org.apache.camel.Processor;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DropboxScheduledPollConsumer
extends ScheduledPollConsumer {
    protected static final transient Logger LOG = LoggerFactory.getLogger(DropboxScheduledPollConsumer.class);
    protected final DropboxEndpoint endpoint;
    protected final DropboxConfiguration configuration;

    protected DropboxScheduledPollConsumer(DropboxEndpoint endpoint, Processor processor, DropboxConfiguration configuration) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    @Override
    protected abstract int poll() throws Exception;

    @Override
    protected void doStart() throws Exception {
        if (this.configuration.getClient() == null) {
            this.configuration.createClient();
            LOG.debug("Consumer Dropbox client created");
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.configuration.getClient() == null) {
            this.configuration.setClient(null);
            LOG.debug("Consumer Dropbox client deleted");
        }
        super.doStop();
    }
}

