/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.producer;

import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DropboxProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DropboxProducer.class);
    protected final DropboxEndpoint endpoint;
    protected final DropboxConfiguration configuration;

    protected DropboxProducer(DropboxEndpoint endpoint, DropboxConfiguration configuration) {
        super(endpoint);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.configuration.getClient() == null) {
            this.configuration.createClient();
            LOG.debug("Producer Dropbox client created");
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.configuration.getClient() == null) {
            this.configuration.setClient(null);
            LOG.debug("Producer Dropbox client deleted");
        }
        super.doStop();
    }
}

