/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Registry;

public class SimpleRegistry
extends LinkedHashMap<String, Map<Class<?>, Object>>
implements Registry,
Closeable {
    @Override
    public Object lookupByName(String name) {
        return this.lookupByNameAndType(name, Object.class);
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Map map = (Map)this.get(name);
        if (map == null) {
            return null;
        }
        Object answer = map.get(type);
        if (answer == null) {
            for (Object value : map.values()) {
                if (!type.isInstance(value)) continue;
                answer = value;
                break;
            }
        }
        if (answer == null) {
            return null;
        }
        try {
            answer = this.unwrap(answer);
            return type.cast(answer);
        }
        catch (Exception e) {
            String msg = "Found bean: " + name + " in SimpleRegistry: " + String.valueOf(this) + " of type: " + answer.getClass().getName() + " expected type was: " + String.valueOf(type);
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>();
        for (Map.Entry entry : this.entrySet()) {
            for (Object value : ((Map)entry.getValue()).values()) {
                if (!type.isInstance(value)) continue;
                value = this.unwrap(value);
                result.put((String)entry.getKey(), type.cast(value));
            }
        }
        return result;
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (Map.Entry entry : this.entrySet()) {
            for (Object value : ((Map)entry.getValue()).values()) {
                if (!type.isInstance(value)) continue;
                value = this.unwrap(value);
                result.add(type.cast(value));
            }
        }
        return result;
    }

    @Override
    public void bind(String id, Class<?> type, Object bean) {
        if (bean != null) {
            this.computeIfAbsent(id, k -> new LinkedHashMap()).put(type, this.wrap(bean));
        }
    }

    @Override
    public void bind(String id, Class<?> type, Supplier<Object> bean) {
        throw new UnsupportedOperationException("Use SupplierRegistry");
    }

    @Override
    public void bindAsPrototype(String id, Class<?> type, Supplier<Object> bean) {
        throw new UnsupportedOperationException("Use SupplierRegistry");
    }

    @Override
    public void unbind(String id) {
        this.remove(id);
    }

    @Override
    public void close() throws IOException {
        this.clear();
    }
}

