/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.control;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlConfiguration;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlConstants;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="dynamic-router-control")
public class DynamicRouterControlComponent
extends DefaultComponent {
    private final Supplier<DynamicRouterControlEndpoint.DynamicRouterControlEndpointFactory> controlEndpointFactorySupplier;

    public DynamicRouterControlComponent() {
        this.controlEndpointFactorySupplier = DynamicRouterControlConstants.CONTROL_ENDPOINT_FACTORY_SUPPLIER;
    }

    public DynamicRouterControlComponent(CamelContext context) {
        super(context);
        this.controlEndpointFactorySupplier = DynamicRouterControlConstants.CONTROL_ENDPOINT_FACTORY_SUPPLIER;
    }

    public DynamicRouterControlComponent(CamelContext context, Supplier<DynamicRouterControlEndpoint.DynamicRouterControlEndpointFactory> controlEndpointFactorySupplier) {
        super(context);
        this.controlEndpointFactorySupplier = controlEndpointFactorySupplier;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DynamicRouterControlConfiguration configuration = new DynamicRouterControlConfiguration();
        DynamicRouterControlEndpoint endpoint = this.controlEndpointFactorySupplier.get().getInstance(uri, this, remaining, configuration);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }
}

