/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.control;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlComponent;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlConfiguration;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlConstants;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlProducer;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlService;
import org.apache.camel.component.dynamicrouter.filter.DynamicRouterFilterService;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.4.0", scheme="dynamic-router-control", title="Dynamic Router Control", syntax="dynamic-router-control:controlAction", producerOnly=true, remote=false, headersClass=DynamicRouterControlConstants.class, category={Category.MESSAGING})
public class DynamicRouterControlEndpoint
extends DefaultEndpoint {
    static final String URI_CONTROL_ACTIONS = "subscribe,unsubscribe,update,list,statistics";
    @UriPath(description="Control action", enums="subscribe,unsubscribe,update,list,statistics")
    @Metadata(required=true)
    private final String controlAction;
    @UriParam
    private final DynamicRouterControlConfiguration configuration;
    private final Supplier<DynamicRouterControlProducer.DynamicRouterControlProducerFactory> controlProducerFactorySupplier;
    private final Supplier<DynamicRouterControlService.DynamicRouterControlServiceFactory> controlServiceFactorySupplier;
    private DynamicRouterControlService controlService;

    public DynamicRouterControlEndpoint(String uri, DynamicRouterControlComponent component, String controlAction, DynamicRouterControlConfiguration configuration, Supplier<DynamicRouterControlProducer.DynamicRouterControlProducerFactory> controlProducerFactorySupplier, Supplier<DynamicRouterControlService.DynamicRouterControlServiceFactory> controlServiceFactorySupplier) {
        super(uri, component);
        this.controlAction = controlAction;
        this.configuration = configuration;
        this.configuration.setControlAction(controlAction);
        this.controlProducerFactorySupplier = controlProducerFactorySupplier;
        this.controlServiceFactorySupplier = controlServiceFactorySupplier;
    }

    public DynamicRouterControlEndpoint(String uri, DynamicRouterControlComponent component, String controlAction, DynamicRouterControlConfiguration configuration) {
        super(uri, component);
        this.controlAction = controlAction;
        this.configuration = configuration;
        this.configuration.setControlAction(controlAction);
        this.controlProducerFactorySupplier = DynamicRouterControlConstants.CONTROL_PRODUCER_FACTORY_SUPPLIER;
        this.controlServiceFactorySupplier = DynamicRouterControlConstants.CONTROL_SERVICE_FACTORY_SUPPLIER;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        DynamicRouterFilterService filterService = Optional.ofNullable(this.getCamelContext().getComponent("dynamic-router", DynamicRouterComponent.class)).map(DynamicRouterComponent::getFilterService).orElseThrow(() -> new IllegalStateException("DynamicRouter component could not be found"));
        this.controlService = this.controlServiceFactorySupplier.get().getInstance(this.getCamelContext(), filterService);
        this.getCamelContext().addService(this.controlService);
    }

    @Override
    protected void doStop() throws Exception {
        this.getCamelContext().removeService(this.controlService);
        super.doStop();
    }

    @Override
    public DynamicRouterControlComponent getComponent() {
        return (DynamicRouterControlComponent)super.getComponent();
    }

    @Override
    public Producer createProducer() {
        return this.controlProducerFactorySupplier.get().getInstance(this, this.controlService, this.configuration);
    }

    @Override
    public Consumer createConsumer(Processor processor) {
        throw new IllegalStateException("Dynamic Router is a producer-only component");
    }

    public String getControlAction() {
        return this.controlAction;
    }

    public DynamicRouterControlConfiguration getConfiguration() {
        return this.configuration;
    }

    public static class DynamicRouterControlEndpointFactory {
        public DynamicRouterControlEndpoint getInstance(String uri, DynamicRouterControlComponent component, String controlAction, DynamicRouterControlConfiguration configuration) {
            return new DynamicRouterControlEndpoint(uri, component, controlAction, configuration);
        }

        public DynamicRouterControlEndpoint getInstance(String uri, DynamicRouterControlComponent component, String controlAction, DynamicRouterControlConfiguration configuration, Supplier<DynamicRouterControlProducer.DynamicRouterControlProducerFactory> controlProducerFactorySupplier, Supplier<DynamicRouterControlService.DynamicRouterControlServiceFactory> controlServiceFactorySupplier) {
            return new DynamicRouterControlEndpoint(uri, component, controlAction, configuration, controlProducerFactorySupplier, controlServiceFactorySupplier);
        }
    }
}

