/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.control;

import org.apache.camel.util.ObjectHelper;

public final class DynamicRouterControlMessage {
    private String subscribeChannel;
    private String subscriptionId;
    private String destinationUri;
    private int priority;
    private String predicateBean;
    private String predicate;
    private String expressionLanguage;

    public DynamicRouterControlMessage() {
    }

    public DynamicRouterControlMessage(String subscribeChannel, String subscriptionId, String destinationUri, int priority, String predicateBean, String predicate, String expressionLanguage) {
        this.subscribeChannel = subscribeChannel;
        this.subscriptionId = subscriptionId;
        this.destinationUri = destinationUri;
        this.priority = priority;
        this.predicateBean = predicateBean;
        this.predicate = predicate;
        this.expressionLanguage = ObjectHelper.isEmpty(expressionLanguage) && ObjectHelper.isNotEmpty(predicate) ? "simple" : expressionLanguage;
    }

    private DynamicRouterControlMessage(Builder builder) {
        this.subscribeChannel = builder.subscribeChannel;
        this.subscriptionId = builder.subscriptionId;
        this.destinationUri = builder.destinationUri;
        this.priority = builder.priority;
        this.predicateBean = builder.predicateBean;
        this.predicate = builder.predicate;
        this.expressionLanguage = builder.expressionLanguage;
    }

    public String getSubscribeChannel() {
        return this.subscribeChannel;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getDestinationUri() {
        return this.destinationUri;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getPredicateBean() {
        return this.predicateBean;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public static final class Builder {
        private String subscribeChannel;
        private String subscriptionId;
        private String destinationUri;
        private int priority;
        private String predicateBean;
        private String predicate;
        private String expressionLanguage;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder subscribeChannel(String val) {
            this.subscribeChannel = val;
            return this;
        }

        public Builder subscriptionId(String val) {
            this.subscriptionId = val;
            return this;
        }

        public Builder destinationUri(String val) {
            this.destinationUri = val;
            return this;
        }

        public Builder priority(int val) {
            this.priority = val;
            return this;
        }

        public Builder predicateBean(String val) {
            this.predicateBean = val;
            return this;
        }

        public Builder predicate(String val) {
            this.predicate = val;
            return this;
        }

        public Builder expressionLanguage(String val) {
            this.expressionLanguage = val;
            return this;
        }

        public DynamicRouterControlMessage build() {
            return new DynamicRouterControlMessage(this);
        }
    }
}

