/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.control;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Converter;
import org.apache.camel.Predicate;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlConstants;
import org.apache.camel.component.dynamicrouter.filter.DynamicRouterFilterService;
import org.apache.camel.component.dynamicrouter.filter.PrioritizedFilter;
import org.apache.camel.component.dynamicrouter.filter.PrioritizedFilterStatistics;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceSupport;

@Converter(generateBulkLoader=true)
@ManagedResource(description="Dynamic Router control operations service")
public class DynamicRouterControlService
extends ServiceSupport {
    private final CamelContext camelContext;
    private final DynamicRouterFilterService filterService;

    public DynamicRouterControlService(CamelContext camelContext, DynamicRouterFilterService filterService) {
        this.camelContext = camelContext;
        this.filterService = filterService;
    }

    static Predicate obtainPredicateFromExpression(CamelContext camelContext, String predExpression, String expressionLanguage) {
        try {
            return camelContext.resolveLanguage(expressionLanguage).createPredicate(predExpression);
        }
        catch (Exception e) {
            String message = String.format("Language '%s' and predicate expression '%s' could not create a valid predicate", expressionLanguage, predExpression);
            throw new IllegalArgumentException(message, e);
        }
    }

    @Converter
    static Predicate obtainPredicateFromBeanName(String predicateBeanName, CamelContext camelContext) {
        return Optional.ofNullable(CamelContextHelper.lookup(camelContext, predicateBeanName, Predicate.class)).orElseThrow(() -> new IllegalStateException("Predicate bean could not be found"));
    }

    static Predicate obtainPredicateFromInstance(Object instance) {
        if (Predicate.class.isAssignableFrom(instance.getClass())) {
            return (Predicate)instance;
        }
        throw new IllegalArgumentException(DynamicRouterControlConstants.ERROR_PREDICATE_CLASS);
    }

    @ManagedOperation(description="Subscribe for dynamic routing with a predicate expression")
    public String subscribeWithPredicateExpression(String subscribeChannel, String subscriptionId, String destinationUri, int priority, String predicate, String expressionLanguage, boolean update) {
        return this.filterService.addFilterForChannel(subscriptionId, priority, DynamicRouterControlService.obtainPredicateFromExpression(this.camelContext, predicate, expressionLanguage), destinationUri, subscribeChannel, update);
    }

    @ManagedOperation(description="Subscribe for dynamic routing with the name of a predicate bean in the registry")
    public String subscribeWithPredicateBean(String subscribeChannel, String subscriptionId, String destinationUri, int priority, String predicateBean, boolean update) {
        return this.filterService.addFilterForChannel(subscriptionId, priority, DynamicRouterControlService.obtainPredicateFromBeanName(predicateBean, this.camelContext), destinationUri, subscribeChannel, update);
    }

    @ManagedOperation(description="Subscribe for dynamic routing with a predicate instance")
    public String subscribeWithPredicateInstance(String subscribeChannel, String subscriptionId, String destinationUri, int priority, Object predicate, boolean update) {
        return this.filterService.addFilterForChannel(subscriptionId, priority, DynamicRouterControlService.obtainPredicateFromInstance(predicate), destinationUri, subscribeChannel, update);
    }

    @ManagedOperation(description="Unsubscribe for dynamic routing on a channel by subscription ID")
    public boolean removeSubscription(String subscribeChannel, String subscriptionId) {
        return this.filterService.removeFilterById(subscriptionId, subscribeChannel);
    }

    @ManagedAttribute(description="Get the map of filters for all dynamic router channels")
    public Map<String, ConcurrentSkipListSet<PrioritizedFilter>> getSubscriptionsMap() {
        return Map.copyOf(this.filterService.getFilterMap());
    }

    @ManagedAttribute(description="Get the map of statistics for all dynamic router channels")
    public Map<String, List<PrioritizedFilterStatistics>> getSubscriptionsStatisticsMap() {
        return Map.copyOf(this.filterService.getFilterStatisticsMap());
    }

    public String getSubscriptionsForChannel(String subscribeChannel) {
        return this.filterService.getFiltersForChannel(subscribeChannel).stream().map(PrioritizedFilter::toString).collect(Collectors.joining(",\n", "[", "]"));
    }

    public String getStatisticsForChannel(String subscribeChannel) {
        return this.filterService.getFiltersForChannel(subscribeChannel).stream().map(PrioritizedFilter::statistics).map(PrioritizedFilterStatistics::toString).collect(Collectors.joining(",\n", "[", "]"));
    }

    public static class DynamicRouterControlServiceFactory {
        public DynamicRouterControlService getInstance(CamelContext camelContext, DynamicRouterFilterService dynamicRouterFilterService) {
            return new DynamicRouterControlService(camelContext, dynamicRouterFilterService);
        }
    }
}

