/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.routing;

import java.util.function.BiFunction;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.component.dynamicrouter.filter.DynamicRouterFilterService;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterConfiguration;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterRecipientListHelper;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.support.AsyncProcessorSupport;

public class DynamicRouterProcessor
extends AsyncProcessorSupport {
    private final boolean warnDroppedMessage;
    private final String channel;
    private final String recipientMode;
    private final RecipientList recipientList;
    private final DynamicRouterFilterService filterService;

    public DynamicRouterProcessor(String recipientMode, boolean warnDroppedMessage, String channel, RecipientList recipientList, DynamicRouterFilterService filterService) {
        this.recipientMode = recipientMode;
        this.warnDroppedMessage = warnDroppedMessage;
        this.channel = channel;
        this.recipientList = recipientList;
        this.filterService = filterService;
    }

    protected String matchFilters(Exchange exchange) {
        return this.filterService.getMatchingEndpointsForExchangeByChannel(exchange, this.channel, "firstMatch".equals(this.recipientMode), this.warnDroppedMessage);
    }

    public void prepareExchange(Exchange exchange) {
        Message message = exchange.getMessage();
        String recipients = this.matchFilters(exchange);
        message.setHeader("DynamicRouterRecipientList", recipients);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.prepareExchange(exchange);
        this.recipientList.process(exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        this.prepareExchange(exchange);
        return this.recipientList.process(exchange, callback);
    }

    public static class DynamicRouterProcessorFactory {
        public DynamicRouterProcessor getInstance(CamelContext camelContext, DynamicRouterConfiguration configuration, DynamicRouterFilterService filterService, BiFunction<CamelContext, Expression, RecipientList> recipientListSupplier) {
            RecipientList recipientList = (RecipientList)DynamicRouterRecipientListHelper.createProcessor(camelContext, configuration, recipientListSupplier);
            return new DynamicRouterProcessor(configuration.getRecipientMode(), configuration.isWarnDroppedMessage(), configuration.getChannel(), recipientList, filterService);
        }
    }
}

