/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.routing;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.component.dynamicrouter.filter.DynamicRouterFilterService;
import org.apache.camel.component.dynamicrouter.filter.PrioritizedFilter;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterConfiguration;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterConstants;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterEndpoint;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterProcessor;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterProducer;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="dynamic-router")
public class DynamicRouterComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRouterComponent.class);
    private final Map<String, DynamicRouterProcessor> processors = new HashMap<String, DynamicRouterProcessor>();
    private final Supplier<DynamicRouterEndpoint.DynamicRouterEndpointFactory> endpointFactorySupplier;
    private final Supplier<DynamicRouterProcessor.DynamicRouterProcessorFactory> processorFactorySupplier;
    private final Supplier<DynamicRouterProducer.DynamicRouterProducerFactory> producerFactorySupplier;
    private final BiFunction<CamelContext, Expression, RecipientList> recipientListSupplier;
    private final DynamicRouterFilterService filterService;

    public DynamicRouterComponent() {
        this.endpointFactorySupplier = DynamicRouterConstants.ENDPOINT_FACTORY_SUPPLIER;
        this.processorFactorySupplier = DynamicRouterConstants.PROCESSOR_FACTORY_SUPPLIER;
        this.producerFactorySupplier = DynamicRouterConstants.PRODUCER_FACTORY_SUPPLIER;
        this.recipientListSupplier = DynamicRouterConstants.RECIPIENT_LIST_SUPPLIER;
        this.filterService = DynamicRouterConstants.FILTER_SERVICE_FACTORY_SUPPLIER.get().getInstance(DynamicRouterConstants.FILTER_FACTORY_SUPPLIER);
        LOG.debug("Created Dynamic Router component");
    }

    public DynamicRouterComponent(Supplier<DynamicRouterEndpoint.DynamicRouterEndpointFactory> endpointFactorySupplier, Supplier<DynamicRouterProcessor.DynamicRouterProcessorFactory> processorFactorySupplier, Supplier<DynamicRouterProducer.DynamicRouterProducerFactory> producerFactorySupplier, BiFunction<CamelContext, Expression, RecipientList> recipientListSupplier, Supplier<PrioritizedFilter.PrioritizedFilterFactory> filterFactorySupplier, Supplier<DynamicRouterFilterService.DynamicRouterFilterServiceFactory> filterServiceFactorySupplier) {
        this.endpointFactorySupplier = endpointFactorySupplier;
        this.processorFactorySupplier = processorFactorySupplier;
        this.producerFactorySupplier = producerFactorySupplier;
        this.recipientListSupplier = recipientListSupplier;
        this.filterService = filterServiceFactorySupplier.get().getInstance(filterFactorySupplier);
        LOG.debug("Created Dynamic Router component");
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty(remaining)) {
            throw new IllegalArgumentException("You must provide a channel for the Dynamic Router");
        }
        DynamicRouterConfiguration configuration = new DynamicRouterConfiguration();
        configuration.setChannel(remaining);
        this.filterService.initializeChannelFilters(configuration.getChannel());
        DynamicRouterEndpoint endpoint = this.endpointFactorySupplier.get().getInstance(uri, this, configuration, this.processorFactorySupplier, this.producerFactorySupplier, this.recipientListSupplier, this.filterService);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.processors);
        this.processors.clear();
        super.doShutdown();
    }

    void addRoutingProcessor(String channel, DynamicRouterProcessor processor) {
        if (this.processors.putIfAbsent(channel, processor) != null) {
            throw new IllegalArgumentException("Dynamic Router can have only one processor per channel; channel '" + channel + "' already has a processor");
        }
    }

    public DynamicRouterProcessor getRoutingProcessor(String channel) {
        return this.processors.get(channel);
    }

    public DynamicRouterFilterService getFilterService() {
        return this.filterService;
    }
}

