/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.impl.engine.BaseExecutorServiceManager;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.ThreadPoolProfile;

public class DefaultExecutorServiceManager
extends BaseExecutorServiceManager {
    public DefaultExecutorServiceManager(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, ThreadPoolProfile profile) {
        return super.newThreadPool(this.forceId(source), name, profile);
    }

    @Override
    public ExecutorService newCachedThreadPool(Object source, String name) {
        return super.newCachedThreadPool(this.forceId(source), name);
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, ThreadPoolProfile profile) {
        return super.newScheduledThreadPool(this.forceId(source), name, profile);
    }

    protected Object forceId(Object source) {
        if (source instanceof NamedNode) {
            NamedNode node = (NamedNode)source;
            if (source instanceof IdAware) {
                IdAware idAware = (IdAware)source;
                NodeIdFactory factory = this.getCamelContext().getCamelContextExtension().getContextPlugin(NodeIdFactory.class);
                if (node.getId() == null) {
                    String id = factory.createId(node);
                    idAware.setGeneratedId(id);
                }
            }
        }
        return source;
    }
}

