/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReferenceCount;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.UserManagedCache;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.FluentCacheConfigurationBuilder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.ehcache.spi.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheManager
extends ServiceSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheManager.class);
    private final EhcacheConfiguration configuration;
    private final CacheManager cacheManager;
    private final ConcurrentMap<String, UserManagedCache<?, ?>> userCaches;
    private final ReferenceCount refCount;

    public EhcacheManager(CacheManager cacheManager, boolean managed, EhcacheConfiguration configuration) {
        this.cacheManager = ObjectHelper.notNull(cacheManager, "cacheManager");
        this.userCaches = new ConcurrentHashMap();
        this.configuration = configuration;
        this.refCount = ReferenceCount.on(managed ? cacheManager::init : () -> {}, managed ? cacheManager::close : () -> {});
    }

    protected void incRef() {
        this.refCount.retain();
    }

    protected void decRef() {
        this.refCount.release();
    }

    @Override
    protected void doShutdown() throws Exception {
        if (this.userCaches != null && !this.userCaches.isEmpty()) {
            for (UserManagedCache cache : this.userCaches.values()) {
                try {
                    cache.close();
                }
                catch (Exception exception) {}
            }
            this.userCaches.clear();
        }
    }

    public <K, V> Cache<K, V> getCache(String name, Class<K> keyType, Class<V> valueType) throws Exception {
        Cache cache;
        Object cacheConfiguration = null;
        if (this.configuration != null) {
            if (this.configuration.hasConfiguration(name)) {
                LOGGER.debug("Using custom cache configuration for cache {}", (Object)name);
                cacheConfiguration = (CacheConfiguration)CacheConfiguration.class.cast(this.configuration.getConfigurations().get(name));
            } else if (this.configuration.hasConfiguration()) {
                LOGGER.debug("Using global cache configuration for cache {}", (Object)name);
                cacheConfiguration = (CacheConfiguration)CacheConfiguration.class.cast(this.configuration.getConfiguration());
            }
        }
        if (keyType == null && valueType == null) {
            if (cacheConfiguration != null) {
                keyType = cacheConfiguration.getKeyType();
                valueType = cacheConfiguration.getValueType();
            } else {
                keyType = Object.class;
                valueType = Object.class;
            }
        }
        if ((cache = this.cacheManager.getCache(name, keyType, valueType)) == null && this.configuration != null && this.configuration.isCreateCacheIfNotExist()) {
            if (cacheConfiguration != null) {
                if (keyType != cacheConfiguration.getKeyType() || valueType != cacheConfiguration.getValueType()) {
                    LOGGER.info("Mismatch keyType / valueType configuration for cache {}", (Object)name);
                    FluentCacheConfigurationBuilder builder = ((CacheConfigurationBuilder)((CacheConfigurationBuilder)CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, cacheConfiguration.getResourcePools()).withClassLoader(cacheConfiguration.getClassLoader())).withEvictionAdvisor(cacheConfiguration.getEvictionAdvisor())).withExpiry(cacheConfiguration.getExpiryPolicy());
                    for (ServiceConfiguration<?, ?> serviceConfig : cacheConfiguration.getServiceConfigurations()) {
                        builder = ((CacheConfigurationBuilder)builder).withService((ServiceConfiguration)serviceConfig);
                    }
                    cacheConfiguration = ((CacheConfigurationBuilder)builder).build();
                }
                cache = this.cacheManager.createCache(name, cacheConfiguration);
            } else {
                LOGGER.debug("Using a UserManagedCache for cache {} as no configuration has been found", (Object)name);
                Class<Object> kt = keyType;
                Class<Object> vt = valueType;
                cache = (Cache)Cache.class.cast(this.userCaches.computeIfAbsent(name, key -> UserManagedCacheBuilder.newUserManagedCacheBuilder(kt, vt).build(true)));
            }
        }
        if (cache == null) {
            throw new RuntimeCamelException("Unable to retrieve the cache " + name + " from cache manager " + String.valueOf(this.cacheManager));
        }
        return cache;
    }

    CacheManager getCacheManager() {
        return this.cacheManager;
    }

    ReferenceCount getReferenceCount() {
        return this.refCount;
    }
}

