/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.FailedToCreateRouteFromTemplateException;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.impl.DefaultModelReifierFactory;
import org.apache.camel.impl.PreconditionHelper;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.BeanModelHelper;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.DefaultRouteTemplateContext;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RouteFilters;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.TemplatedRouteParameterDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.RouteTemplateLoaderListener;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.RouteTemplateHelper;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class DefaultModel
implements Model {
    private final CamelContext camelContext;
    private ModelReifierFactory modelReifierFactory = new DefaultModelReifierFactory();
    private final List<ModelLifecycleStrategy> modelLifecycleStrategies = new ArrayList<ModelLifecycleStrategy>();
    private final List<RouteConfigurationDefinition> routesConfigurations = new ArrayList<RouteConfigurationDefinition>();
    private final List<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
    private final List<RouteTemplateDefinition> routeTemplateDefinitions = new ArrayList<RouteTemplateDefinition>();
    private final List<RestDefinition> restDefinitions = new ArrayList<RestDefinition>();
    private final Map<String, RouteTemplateDefinition.Converter> routeTemplateConverters = new ConcurrentHashMap<String, RouteTemplateDefinition.Converter>();
    private Map<String, DataFormatDefinition> dataFormats = new HashMap<String, DataFormatDefinition>();
    private List<TransformerDefinition> transformers = new ArrayList<TransformerDefinition>();
    private List<ValidatorDefinition> validators = new ArrayList<ValidatorDefinition>();
    private final List<BeanFactoryDefinition<?>> beans = new ArrayList();
    private final Map<String, ServiceCallConfigurationDefinition> serviceCallConfigurations = new ConcurrentHashMap<String, ServiceCallConfigurationDefinition>();
    private final Map<String, Resilience4jConfigurationDefinition> resilience4jConfigurations = new ConcurrentHashMap<String, Resilience4jConfigurationDefinition>();
    private final Map<String, FaultToleranceConfigurationDefinition> faultToleranceConfigurations = new ConcurrentHashMap<String, FaultToleranceConfigurationDefinition>();
    private Function<RouteDefinition, Boolean> routeFilter;

    public DefaultModel(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void addModelLifecycleStrategy(ModelLifecycleStrategy modelLifecycleStrategy) {
        if (!this.modelLifecycleStrategies.contains(modelLifecycleStrategy)) {
            this.modelLifecycleStrategies.add(modelLifecycleStrategy);
        }
    }

    @Override
    public List<ModelLifecycleStrategy> getModelLifecycleStrategies() {
        return this.modelLifecycleStrategies;
    }

    @Override
    public void addRouteConfiguration(RouteConfigurationDefinition routesConfiguration) {
        if (routesConfiguration == null || !this.includedRouteConfiguration(routesConfiguration)) {
            return;
        }
        if (!this.routesConfigurations.contains(routesConfiguration)) {
            boolean clash;
            if (routesConfiguration.getId() != null && (clash = this.routesConfigurations.stream().anyMatch(r -> ObjectHelper.equal(r.getId(), routesConfiguration.getId())))) {
                throw new IllegalArgumentException("Route configuration already exists with id: " + routesConfiguration.getId());
            }
            this.routesConfigurations.add(routesConfiguration);
        }
    }

    @Override
    public void addRouteConfigurations(List<RouteConfigurationDefinition> routesConfigurations) {
        if (routesConfigurations == null || routesConfigurations.isEmpty()) {
            return;
        }
        for (RouteConfigurationDefinition rc : routesConfigurations) {
            this.addRouteConfiguration(rc);
        }
    }

    @Override
    public List<RouteConfigurationDefinition> getRouteConfigurationDefinitions() {
        return this.routesConfigurations;
    }

    @Override
    public synchronized RouteConfigurationDefinition getRouteConfigurationDefinition(String id) {
        for (RouteConfigurationDefinition def : this.routesConfigurations) {
            if (!def.idOrCreate(this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class)).equals(id)) continue;
            return def;
        }
        return this.routesConfigurations.stream().filter(c -> c.getId() == null).findFirst().orElse(null);
    }

    @Override
    public void removeRouteConfiguration(RouteConfigurationDefinition routeConfigurationDefinition) throws Exception {
        RouteConfigurationDefinition toBeRemoved = this.getRouteConfigurationDefinition(routeConfigurationDefinition.getId());
        this.routesConfigurations.remove(toBeRemoved);
    }

    @Override
    public synchronized void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        ArrayList<RouteDefinition> list;
        if (routeDefinitions == null || routeDefinitions.isEmpty()) {
            return;
        }
        if (this.routeFilter == null) {
            list = new ArrayList<RouteDefinition>(routeDefinitions);
        } else {
            list = new ArrayList();
            for (RouteDefinition r : routeDefinitions) {
                if (!this.routeFilter.apply(r).booleanValue()) continue;
                list.add(r);
            }
        }
        this.removeRouteDefinitions(list);
        if (this.camelContext.getRestConfiguration().isInlineRoutes()) {
            String uri;
            FromDefinition from;
            ArrayList<RouteDefinition> allRoutes = new ArrayList<RouteDefinition>();
            allRoutes.addAll(list);
            allRoutes.addAll(this.routeDefinitions);
            ArrayList<RouteDefinition> toBeRemoved = new ArrayList<RouteDefinition>();
            HashMap<String, RouteDefinition> directs = new HashMap<String, RouteDefinition>();
            for (RouteDefinition r : allRoutes) {
                from = r.getInput();
                if (from == null || (uri = from.getEndpointUri()) == null || !uri.startsWith("direct:")) continue;
                directs.put(uri, r);
            }
            for (RouteDefinition r : allRoutes) {
                String toUri;
                RouteDefinition toBeInlined;
                from = r.getInput();
                if (from == null || (uri = from.getEndpointUri()) == null || !uri.startsWith("rest:")) continue;
                SendDefinition to = null;
                for (ProcessorDefinition<?> def : r.getOutputs()) {
                    if (def.isAbstract()) continue;
                    if (!(def instanceof ToDefinition)) break;
                    ToDefinition toDefinition = (ToDefinition)def;
                    to = toDefinition;
                    break;
                }
                if (to == null || (toBeInlined = (RouteDefinition)directs.get(toUri = to.getEndpointUri())) == null) continue;
                toBeRemoved.add(toBeInlined);
                FromDefinition inlinedFrom = toBeInlined.getInput();
                from.setLocation(inlinedFrom.getLocation());
                from.setLineNumber(inlinedFrom.getLineNumber());
                ArrayList toBeRemovedOut = new ArrayList();
                for (ProcessorDefinition<?> out : r.getOutputs()) {
                    boolean remove = toBeInlined.getOutputs().stream().anyMatch(o -> o == out);
                    if (!remove) {
                        boolean bl = remove = !out.isAbstract();
                    }
                    if (!remove) continue;
                    toBeRemovedOut.add(out);
                }
                r.getOutputs().removeAll(toBeRemovedOut);
                r.getOutputs().addAll(toBeInlined.getOutputs());
                if (toBeInlined.getRouteId() != null) {
                    r.setId(toBeInlined.getRouteId());
                }
                r.setNodePrefixId(toBeInlined.getNodePrefixId());
                r.setGroup(toBeInlined.getGroup());
                r.setAutoStartup(toBeInlined.getAutoStartup());
                r.setDelayer(toBeInlined.getDelayer());
                r.setInputType(toBeInlined.getInputType());
                r.setOutputType(toBeInlined.getOutputType());
                r.setLogMask(toBeInlined.getLogMask());
                r.setMessageHistory(toBeInlined.getMessageHistory());
                r.setStreamCache(toBeInlined.getStreamCache());
                r.setTrace(toBeInlined.getTrace());
                r.setStartupOrder(toBeInlined.getStartupOrder());
                r.setRoutePolicyRef(toBeInlined.getRoutePolicyRef());
                r.setRouteConfigurationId(toBeInlined.getRouteConfigurationId());
                r.setRoutePolicies(toBeInlined.getRoutePolicies());
                r.setShutdownRoute(toBeInlined.getShutdownRoute());
                r.setShutdownRunningTask(toBeInlined.getShutdownRunningTask());
                r.setErrorHandlerRef(toBeInlined.getErrorHandlerRef());
                r.setPrecondition(toBeInlined.getPrecondition());
                if (!toBeInlined.isErrorHandlerFactorySet()) continue;
                r.setErrorHandler(toBeInlined.getErrorHandler());
            }
            list.removeAll(toBeRemoved);
            this.routeDefinitions.removeAll(toBeRemoved);
        }
        for (RouteDefinition r : list) {
            for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
                s.onAddRouteDefinition(r);
            }
            this.routeDefinitions.add(r);
        }
        if (this.shouldStartRoutes()) {
            ((ModelCamelContext)this.getCamelContext()).startRouteDefinitions(list);
        }
    }

    @Override
    public void addRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        this.addRouteDefinitions(Collections.singletonList(routeDefinition));
    }

    @Override
    public synchronized void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.removeRouteDefinition(routeDefinition);
        }
    }

    @Override
    public synchronized void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        RouteDefinition toBeRemoved = routeDefinition;
        String id = routeDefinition.getId();
        if (id != null) {
            this.camelContext.getRouteController().stopRoute(id);
            this.camelContext.removeRoute(id);
            toBeRemoved = this.getRouteDefinition(id);
        }
        for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
            s.onRemoveRouteDefinition(toBeRemoved);
        }
        this.routeDefinitions.remove(toBeRemoved);
    }

    @Override
    public synchronized void removeRouteTemplateDefinitions(String pattern) throws Exception {
        for (RouteTemplateDefinition def : new ArrayList<RouteTemplateDefinition>(this.routeTemplateDefinitions)) {
            if (!PatternHelper.matchPattern(def.getId(), pattern)) continue;
            this.removeRouteTemplateDefinition(def);
        }
    }

    @Override
    public synchronized List<RouteDefinition> getRouteDefinitions() {
        return this.routeDefinitions;
    }

    @Override
    public synchronized RouteDefinition getRouteDefinition(String id) {
        for (RouteDefinition route : this.routeDefinitions) {
            if (!route.idOrCreate(this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class)).equals(id)) continue;
            return route;
        }
        return null;
    }

    @Override
    public List<RouteTemplateDefinition> getRouteTemplateDefinitions() {
        return this.routeTemplateDefinitions;
    }

    @Override
    public RouteTemplateDefinition getRouteTemplateDefinition(String id) {
        for (RouteTemplateDefinition route : this.routeTemplateDefinitions) {
            if (!route.idOrCreate(this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class)).equals(id)) continue;
            return route;
        }
        return null;
    }

    @Override
    public void addRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        if (routeTemplateDefinitions == null || routeTemplateDefinitions.isEmpty()) {
            return;
        }
        for (RouteTemplateDefinition r : routeTemplateDefinitions) {
            for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
                s.onAddRouteTemplateDefinition(r);
            }
            this.routeTemplateDefinitions.add(r);
        }
    }

    @Override
    public void addRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        this.addRouteTemplateDefinitions(Collections.singletonList(routeTemplateDefinition));
    }

    @Override
    public void removeRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        for (RouteTemplateDefinition r : routeTemplateDefinitions) {
            this.removeRouteTemplateDefinition(r);
        }
    }

    @Override
    public void removeRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
            s.onRemoveRouteTemplateDefinition(routeTemplateDefinition);
        }
        this.routeTemplateDefinitions.remove(routeTemplateDefinition);
    }

    @Override
    public void addRouteTemplateDefinitionConverter(String templateIdPattern, RouteTemplateDefinition.Converter converter) {
        this.routeTemplateConverters.put(templateIdPattern, converter);
    }

    @Override
    @Deprecated(since="3.10.0")
    public String addRouteFromTemplate(String routeId, String routeTemplateId, Map<String, Object> parameters) throws Exception {
        DefaultRouteTemplateContext rtc = new DefaultRouteTemplateContext(this.camelContext);
        if (parameters != null) {
            parameters.forEach(rtc::setParameter);
        }
        return this.addRouteFromTemplate(routeId, routeTemplateId, null, rtc);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, Map<String, Object> parameters) throws Exception {
        DefaultRouteTemplateContext rtc = new DefaultRouteTemplateContext(this.camelContext);
        if (parameters != null) {
            parameters.forEach(rtc::setParameter);
        }
        return this.addRouteFromTemplate(routeId, routeTemplateId, prefixId, rtc);
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, RouteTemplateContext routeTemplateContext) throws Exception {
        return this.addRouteFromTemplate(routeId, routeTemplateId, null, routeTemplateContext);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, RouteTemplateContext routeTemplateContext) throws Exception {
        String string;
        RouteTemplateDefinition target = null;
        for (RouteTemplateDefinition def : this.routeTemplateDefinitions) {
            if (!routeTemplateId.equals(def.getId())) continue;
            target = def;
            break;
        }
        if (target == null) {
            Object location = routeTemplateContext.getParameters().get("location");
            if (location != null) {
                RouteTemplateLoaderListener listener = CamelContextHelper.findSingleByType(this.getCamelContext(), RouteTemplateLoaderListener.class);
                RouteTemplateHelper.loadRouteTemplateFromLocation(this.getCamelContext(), listener, routeTemplateId, location.toString());
            }
            for (RouteTemplateDefinition def : this.routeTemplateDefinitions) {
                if (!routeTemplateId.equals(def.getId())) continue;
                target = def;
                break;
            }
        }
        if (target == null) {
            throw new IllegalArgumentException("Cannot find RouteTemplate with id " + routeTemplateId);
        }
        HashMap<String, Object> prop = new HashMap<String, Object>();
        HashMap<String, Object> propDefaultValues = new HashMap<String, Object>();
        if (target.getTemplateParameters() != null) {
            StringJoiner missingParameters = new StringJoiner(", ");
            for (RouteTemplateParameterDefinition routeTemplateParameterDefinition : target.getTemplateParameters()) {
                if (routeTemplateParameterDefinition.getDefaultValue() != null) {
                    DefaultModel.addProperty(prop, routeTemplateParameterDefinition.getName(), routeTemplateParameterDefinition.getDefaultValue());
                    DefaultModel.addProperty(propDefaultValues, routeTemplateParameterDefinition.getName(), routeTemplateParameterDefinition.getDefaultValue());
                    continue;
                }
                if (routeTemplateContext.hasEnvironmentVariable(routeTemplateParameterDefinition.getName())) {
                    DefaultModel.addProperty(prop, routeTemplateParameterDefinition.getName(), routeTemplateContext.getEnvironmentVariable(routeTemplateParameterDefinition.getName()));
                    continue;
                }
                if (!routeTemplateParameterDefinition.isRequired() || routeTemplateContext.hasParameter(routeTemplateParameterDefinition.getName())) continue;
                missingParameters.add(routeTemplateParameterDefinition.getName());
            }
            if (missingParameters.length() > 0) {
                throw new IllegalArgumentException("Route template " + routeTemplateId + " the following mandatory parameters must be provided: " + String.valueOf(missingParameters));
            }
        }
        if (routeTemplateContext.getParameters() != null) {
            routeTemplateContext.getParameters().forEach((k, v) -> DefaultModel.addProperty(prop, k, v));
        }
        if (target.getTemplateParameters() != null) {
            for (RouteTemplateParameterDefinition routeTemplateParameterDefinition : target.getTemplateParameters()) {
                if (routeTemplateContext.hasParameter(routeTemplateParameterDefinition.getName()) || routeTemplateParameterDefinition.getDefaultValue() == null) continue;
                routeTemplateContext.setParameter(routeTemplateParameterDefinition.getName(), routeTemplateParameterDefinition.getDefaultValue());
            }
        }
        RouteTemplateDefinition.Converter converter = RouteTemplateDefinition.Converter.DEFAULT_CONVERTER;
        for (Map.Entry<String, RouteTemplateDefinition.Converter> entry : this.routeTemplateConverters.entrySet()) {
            String key = entry.getKey();
            String templateId = target.getId();
            if ("*".equals(key) || templateId.equals(key)) {
                converter = entry.getValue();
                break;
            }
            if (AntPathMatcher.INSTANCE.match(key, templateId)) {
                converter = entry.getValue();
                break;
            }
            if (!templateId.matches(key)) continue;
            converter = entry.getValue();
            break;
        }
        RouteDefinition routeDefinition = converter.apply(target, prop);
        if (routeId != null) {
            routeDefinition.setId(routeId);
        }
        if (prefixId != null) {
            routeDefinition.setNodePrefixId(prefixId);
        }
        routeDefinition.setTemplateParameters(prop);
        routeDefinition.setTemplateDefaultParameters(propDefaultValues);
        routeDefinition.setRouteTemplateContext(routeTemplateContext);
        if (target.getTemplateBeans() != null) {
            DefaultModel.addTemplateBeans(routeTemplateContext, target);
        }
        if (target.getConfigurer() != null) {
            routeTemplateContext.setConfigurer(target.getConfigurer());
        }
        if ((string = RouteDefinitionHelper.validateUniqueIds(routeDefinition, this.routeDefinitions, prefixId)) != null) {
            throw new FailedToCreateRouteFromTemplateException(routeId, routeTemplateId, "duplicate id detected: " + string + ". Please correct ids to be unique among all your routes.");
        }
        RoutesDefinition routeCollection = new RoutesDefinition();
        routeCollection.setCamelContext(this.camelContext);
        routeCollection.setRoutes(this.getRouteDefinitions());
        routeCollection.prepareRoute(routeDefinition);
        this.addRouteDefinition(routeDefinition);
        return routeDefinition.getId();
    }

    private static void addProperty(Map<String, Object> prop, String key, Object value) {
        prop.put(key, value);
        key = StringHelper.dashToCamelCase(key);
        prop.put(key, value);
        key = StringHelper.camelCaseToDash(key);
        prop.put(key, value);
    }

    private static void addTemplateBeans(RouteTemplateContext routeTemplateContext, RouteTemplateDefinition target) throws Exception {
        for (BeanFactoryDefinition<RouteTemplateDefinition> b : target.getTemplateBeans()) {
            BeanModelHelper.bind(b, routeTemplateContext);
        }
    }

    @Override
    public void addRouteFromTemplatedRoute(TemplatedRouteDefinition templatedRouteDefinition) throws Exception {
        ObjectHelper.notNull(templatedRouteDefinition, "templatedRouteDefinition");
        RouteTemplateContext routeTemplateContext = this.toRouteTemplateContext(templatedRouteDefinition);
        List<BeanFactoryDefinition<TemplatedRouteDefinition>> beans = templatedRouteDefinition.getBeans();
        if (beans != null) {
            for (BeanFactoryDefinition<TemplatedRouteDefinition> beanDefinition : beans) {
                BeanModelHelper.bind(beanDefinition, routeTemplateContext);
            }
        }
        this.addRouteFromTemplate(templatedRouteDefinition.getRouteId(), templatedRouteDefinition.getRouteTemplateRef(), templatedRouteDefinition.getPrefixId(), routeTemplateContext);
    }

    private RouteTemplateContext toRouteTemplateContext(TemplatedRouteDefinition templatedRouteDefinition) {
        DefaultRouteTemplateContext routeTemplateContext = new DefaultRouteTemplateContext(this.camelContext);
        List<TemplatedRouteParameterDefinition> parameters = templatedRouteDefinition.getParameters();
        if (parameters != null) {
            for (TemplatedRouteParameterDefinition parameterDefinition : parameters) {
                routeTemplateContext.setParameter(parameterDefinition.getName(), parameterDefinition.getValue());
            }
        }
        return routeTemplateContext;
    }

    @Override
    public synchronized List<RestDefinition> getRestDefinitions() {
        return this.restDefinitions;
    }

    @Override
    public synchronized void addRestDefinitions(Collection<RestDefinition> restDefinitions, boolean addToRoutes) throws Exception {
        if (restDefinitions == null || restDefinitions.isEmpty()) {
            return;
        }
        this.restDefinitions.addAll(restDefinitions);
        if (addToRoutes) {
            for (RestDefinition restDefinition : restDefinitions) {
                List<RouteDefinition> routeDefinitions = restDefinition.asRouteDefinition(this.camelContext);
                this.addRouteDefinitions(routeDefinitions);
            }
        }
    }

    @Override
    public ServiceCallConfigurationDefinition getServiceCallConfiguration(String serviceName) {
        if (serviceName == null) {
            serviceName = "";
        }
        return this.serviceCallConfigurations.get(serviceName);
    }

    @Override
    public void setServiceCallConfiguration(ServiceCallConfigurationDefinition configuration) {
        this.serviceCallConfigurations.put("", configuration);
    }

    @Override
    public void setServiceCallConfigurations(List<ServiceCallConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (ServiceCallConfigurationDefinition configuration : configurations) {
                this.serviceCallConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    @Override
    public void addServiceCallConfiguration(String serviceName, ServiceCallConfigurationDefinition configuration) {
        this.serviceCallConfigurations.put(serviceName, configuration);
    }

    @Override
    public Resilience4jConfigurationDefinition getResilience4jConfiguration(String id) {
        if (id == null) {
            id = "";
        }
        return this.resilience4jConfigurations.get(id);
    }

    @Override
    public void setResilience4jConfiguration(Resilience4jConfigurationDefinition configuration) {
        this.resilience4jConfigurations.put("", configuration);
    }

    @Override
    public void setResilience4jConfigurations(List<Resilience4jConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (Resilience4jConfigurationDefinition configuration : configurations) {
                this.resilience4jConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    @Override
    public void addResilience4jConfiguration(String id, Resilience4jConfigurationDefinition configuration) {
        this.resilience4jConfigurations.put(id, configuration);
    }

    @Override
    public FaultToleranceConfigurationDefinition getFaultToleranceConfiguration(String id) {
        if (id == null) {
            id = "";
        }
        return this.faultToleranceConfigurations.get(id);
    }

    @Override
    public void setFaultToleranceConfiguration(FaultToleranceConfigurationDefinition configuration) {
        this.faultToleranceConfigurations.put("", configuration);
    }

    @Override
    public void setFaultToleranceConfigurations(List<FaultToleranceConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (FaultToleranceConfigurationDefinition configuration : configurations) {
                this.faultToleranceConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    @Override
    public void addFaultToleranceConfiguration(String id, FaultToleranceConfigurationDefinition configuration) {
        this.faultToleranceConfigurations.put(id, configuration);
    }

    @Override
    public DataFormatDefinition resolveDataFormatDefinition(String name) {
        DataFormatDefinition type = DefaultModel.lookup(this.camelContext, name, DataFormatDefinition.class);
        if (type == null && this.getDataFormats() != null) {
            type = this.getDataFormats().get(name);
        }
        return type;
    }

    @Override
    public ProcessorDefinition<?> getProcessorDefinition(String id) {
        for (RouteDefinition route : this.getRouteDefinitions()) {
            Collection<ProcessorDefinition> col = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ProcessorDefinition.class);
            for (ProcessorDefinition proc : col) {
                Object pid = proc.getId();
                if (id.equals(pid)) {
                    return proc;
                }
                if (proc.getNodePrefixId() == null || !id.equals(pid = proc.getNodePrefixId() + (String)pid)) continue;
                return proc;
            }
        }
        return null;
    }

    @Override
    public <T extends ProcessorDefinition<T>> T getProcessorDefinition(String id, Class<T> type) {
        ProcessorDefinition<?> answer = this.getProcessorDefinition(id);
        if (answer != null) {
            return (T)((ProcessorDefinition)type.cast(answer));
        }
        return null;
    }

    @Override
    public Map<String, DataFormatDefinition> getDataFormats() {
        return this.dataFormats;
    }

    @Override
    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        this.dataFormats = dataFormats;
    }

    @Override
    public List<TransformerDefinition> getTransformers() {
        return this.transformers;
    }

    @Override
    public void setTransformers(List<TransformerDefinition> transformers) {
        this.transformers = transformers;
    }

    @Override
    public List<ValidatorDefinition> getValidators() {
        return this.validators;
    }

    @Override
    public void setValidators(List<ValidatorDefinition> validators) {
        this.validators = validators;
    }

    @Override
    public void setRouteFilterPattern(String include, String exclude) {
        this.setRouteFilter(RouteFilters.filterByPattern(include, exclude));
    }

    @Override
    public Function<RouteDefinition, Boolean> getRouteFilter() {
        return this.routeFilter;
    }

    @Override
    public void setRouteFilter(Function<RouteDefinition, Boolean> routeFilter) {
        this.routeFilter = routeFilter;
    }

    @Override
    public ModelReifierFactory getModelReifierFactory() {
        return this.modelReifierFactory;
    }

    @Override
    public void setModelReifierFactory(ModelReifierFactory modelReifierFactory) {
        this.modelReifierFactory = modelReifierFactory;
    }

    @Override
    public void addCustomBean(BeanFactoryDefinition<?> bean) {
        this.beans.removeIf(b -> bean.getName().equals(b.getName()));
        this.beans.add(bean);
    }

    @Override
    public List<BeanFactoryDefinition<?>> getCustomBeans() {
        return this.beans;
    }

    protected boolean shouldStartRoutes() {
        return this.camelContext.isStarted() && !this.camelContext.isStarting();
    }

    private static <T> T lookup(CamelContext context, String ref, Class<T> type) {
        try {
            return context.getRegistry().lookupByNameAndType(ref, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean includedRouteConfiguration(RouteConfigurationDefinition definition) {
        return PreconditionHelper.included(definition, this.camelContext);
    }
}

