/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.connector.ConnectorFieldType;
import co.elastic.clients.elasticsearch.connector.Dependency;
import co.elastic.clients.elasticsearch.connector.DisplayType;
import co.elastic.clients.elasticsearch.connector.SelectOption;
import co.elastic.clients.elasticsearch.connector.Validation;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ConnectorConfigProperties
implements JsonpSerializable {
    @Nullable
    private final String category;
    private final FieldValue defaultValue;
    private final List<Dependency> dependsOn;
    private final DisplayType display;
    private final String label;
    private final List<SelectOption> options;
    @Nullable
    private final Integer order;
    @Nullable
    private final String placeholder;
    private final boolean required;
    private final boolean sensitive;
    @Nullable
    private final String tooltip;
    @Nullable
    private final ConnectorFieldType type;
    private final List<String> uiRestrictions;
    private final List<Validation> validations;
    private final JsonData value;
    public static final JsonpDeserializer<ConnectorConfigProperties> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConnectorConfigProperties::setupConnectorConfigPropertiesDeserializer);

    private ConnectorConfigProperties(Builder builder) {
        this.category = builder.category;
        this.defaultValue = ApiTypeHelper.requireNonNull(builder.defaultValue, this, "defaultValue");
        this.dependsOn = ApiTypeHelper.unmodifiableRequired(builder.dependsOn, (Object)this, "dependsOn");
        this.display = ApiTypeHelper.requireNonNull(builder.display, this, "display");
        this.label = ApiTypeHelper.requireNonNull(builder.label, this, "label");
        this.options = ApiTypeHelper.unmodifiableRequired(builder.options, (Object)this, "options");
        this.order = builder.order;
        this.placeholder = builder.placeholder;
        this.required = ApiTypeHelper.requireNonNull(builder.required, this, "required");
        this.sensitive = ApiTypeHelper.requireNonNull(builder.sensitive, this, "sensitive");
        this.tooltip = builder.tooltip;
        this.type = builder.type;
        this.uiRestrictions = ApiTypeHelper.unmodifiable(builder.uiRestrictions);
        this.validations = ApiTypeHelper.unmodifiable(builder.validations);
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static ConnectorConfigProperties of(Function<Builder, ObjectBuilder<ConnectorConfigProperties>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String category() {
        return this.category;
    }

    public final FieldValue defaultValue() {
        return this.defaultValue;
    }

    public final List<Dependency> dependsOn() {
        return this.dependsOn;
    }

    public final DisplayType display() {
        return this.display;
    }

    public final String label() {
        return this.label;
    }

    public final List<SelectOption> options() {
        return this.options;
    }

    @Nullable
    public final Integer order() {
        return this.order;
    }

    @Nullable
    public final String placeholder() {
        return this.placeholder;
    }

    public final boolean required() {
        return this.required;
    }

    public final boolean sensitive() {
        return this.sensitive;
    }

    @Nullable
    public final String tooltip() {
        return this.tooltip;
    }

    @Nullable
    public final ConnectorFieldType type() {
        return this.type;
    }

    public final List<String> uiRestrictions() {
        return this.uiRestrictions;
    }

    public final List<Validation> validations() {
        return this.validations;
    }

    public final JsonData value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.category != null) {
            generator.writeKey("category");
            generator.write(this.category);
        }
        generator.writeKey("default_value");
        this.defaultValue.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.dependsOn)) {
            generator.writeKey("depends_on");
            generator.writeStartArray();
            for (Dependency dependency : this.dependsOn) {
                dependency.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("display");
        this.display.serialize(generator, mapper);
        generator.writeKey("label");
        generator.write(this.label);
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartArray();
            for (SelectOption selectOption : this.options) {
                selectOption.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.order != null) {
            generator.writeKey("order");
            generator.write(this.order);
        }
        if (this.placeholder != null) {
            generator.writeKey("placeholder");
            generator.write(this.placeholder);
        }
        generator.writeKey("required");
        generator.write(this.required);
        generator.writeKey("sensitive");
        generator.write(this.sensitive);
        if (this.tooltip != null) {
            generator.writeKey("tooltip");
            generator.write(this.tooltip);
        }
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.uiRestrictions)) {
            generator.writeKey("ui_restrictions");
            generator.writeStartArray();
            for (String string : this.uiRestrictions) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.validations)) {
            generator.writeKey("validations");
            generator.writeStartArray();
            for (Validation validation : this.validations) {
                validation.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupConnectorConfigPropertiesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::category, JsonpDeserializer.stringDeserializer(), "category");
        op.add(Builder::defaultValue, FieldValue._DESERIALIZER, "default_value");
        op.add(Builder::dependsOn, JsonpDeserializer.arrayDeserializer(Dependency._DESERIALIZER), "depends_on");
        op.add(Builder::display, DisplayType._DESERIALIZER, "display");
        op.add(Builder::label, JsonpDeserializer.stringDeserializer(), "label");
        op.add(Builder::options, JsonpDeserializer.arrayDeserializer(SelectOption._DESERIALIZER), "options");
        op.add(Builder::order, JsonpDeserializer.integerDeserializer(), "order");
        op.add(Builder::placeholder, JsonpDeserializer.stringDeserializer(), "placeholder");
        op.add(Builder::required, JsonpDeserializer.booleanDeserializer(), "required");
        op.add(Builder::sensitive, JsonpDeserializer.booleanDeserializer(), "sensitive");
        op.add(Builder::tooltip, JsonpDeserializer.stringDeserializer(), "tooltip");
        op.add(Builder::type, ConnectorFieldType._DESERIALIZER, "type");
        op.add(Builder::uiRestrictions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ui_restrictions");
        op.add(Builder::validations, JsonpDeserializer.arrayDeserializer(Validation._DESERIALIZER), "validations");
        op.add(Builder::value, JsonData._DESERIALIZER, "value");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ConnectorConfigProperties> {
        @Nullable
        private String category;
        private FieldValue defaultValue;
        private List<Dependency> dependsOn;
        private DisplayType display;
        private String label;
        private List<SelectOption> options;
        @Nullable
        private Integer order;
        @Nullable
        private String placeholder;
        private Boolean required;
        private Boolean sensitive;
        @Nullable
        private String tooltip;
        @Nullable
        private ConnectorFieldType type;
        @Nullable
        private List<String> uiRestrictions;
        @Nullable
        private List<Validation> validations;
        private JsonData value;

        public final Builder category(@Nullable String value) {
            this.category = value;
            return this;
        }

        public final Builder defaultValue(FieldValue value) {
            this.defaultValue = value;
            return this;
        }

        public final Builder defaultValue(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.defaultValue(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder defaultValue(String value) {
            this.defaultValue = FieldValue.of(value);
            return this;
        }

        public final Builder defaultValue(long value) {
            this.defaultValue = FieldValue.of(value);
            return this;
        }

        public final Builder defaultValue(double value) {
            this.defaultValue = FieldValue.of(value);
            return this;
        }

        public final Builder defaultValue(boolean value) {
            this.defaultValue = FieldValue.of(value);
            return this;
        }

        public final Builder dependsOn(List<Dependency> list) {
            this.dependsOn = Builder._listAddAll(this.dependsOn, list);
            return this;
        }

        public final Builder dependsOn(Dependency value, Dependency ... values) {
            this.dependsOn = Builder._listAdd(this.dependsOn, value, values);
            return this;
        }

        public final Builder dependsOn(Function<Dependency.Builder, ObjectBuilder<Dependency>> fn) {
            return this.dependsOn(fn.apply(new Dependency.Builder()).build(), new Dependency[0]);
        }

        public final Builder display(DisplayType value) {
            this.display = value;
            return this;
        }

        public final Builder label(String value) {
            this.label = value;
            return this;
        }

        public final Builder options(List<SelectOption> list) {
            this.options = Builder._listAddAll(this.options, list);
            return this;
        }

        public final Builder options(SelectOption value, SelectOption ... values) {
            this.options = Builder._listAdd(this.options, value, values);
            return this;
        }

        public final Builder options(Function<SelectOption.Builder, ObjectBuilder<SelectOption>> fn) {
            return this.options(fn.apply(new SelectOption.Builder()).build(), new SelectOption[0]);
        }

        public final Builder order(@Nullable Integer value) {
            this.order = value;
            return this;
        }

        public final Builder placeholder(@Nullable String value) {
            this.placeholder = value;
            return this;
        }

        public final Builder required(boolean value) {
            this.required = value;
            return this;
        }

        public final Builder sensitive(boolean value) {
            this.sensitive = value;
            return this;
        }

        public final Builder tooltip(@Nullable String value) {
            this.tooltip = value;
            return this;
        }

        public final Builder type(@Nullable ConnectorFieldType value) {
            this.type = value;
            return this;
        }

        public final Builder uiRestrictions(List<String> list) {
            this.uiRestrictions = Builder._listAddAll(this.uiRestrictions, list);
            return this;
        }

        public final Builder uiRestrictions(String value, String ... values) {
            this.uiRestrictions = Builder._listAdd(this.uiRestrictions, value, values);
            return this;
        }

        public final Builder validations(List<Validation> list) {
            this.validations = Builder._listAddAll(this.validations, list);
            return this;
        }

        public final Builder validations(Validation value, Validation ... values) {
            this.validations = Builder._listAdd(this.validations, value, values);
            return this;
        }

        public final Builder validations(Function<Validation.Builder, ObjectBuilder<Validation>> fn) {
            return this.validations(fn.apply(new Validation.Builder()).build(), new Validation[0]);
        }

        public final Builder value(JsonData value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ConnectorConfigProperties build() {
            this._checkSingleUse();
            return new ConnectorConfigProperties(this);
        }
    }
}

