/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.IlmPolicyStatistics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Ilm
implements JsonpSerializable {
    private final int policyCount;
    private final List<IlmPolicyStatistics> policyStats;
    public static final JsonpDeserializer<Ilm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ilm::setupIlmDeserializer);

    private Ilm(Builder builder) {
        this.policyCount = ApiTypeHelper.requireNonNull(builder.policyCount, this, "policyCount");
        this.policyStats = ApiTypeHelper.unmodifiableRequired(builder.policyStats, (Object)this, "policyStats");
    }

    public static Ilm of(Function<Builder, ObjectBuilder<Ilm>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int policyCount() {
        return this.policyCount;
    }

    public final List<IlmPolicyStatistics> policyStats() {
        return this.policyStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("policy_count");
        generator.write(this.policyCount);
        if (ApiTypeHelper.isDefined(this.policyStats)) {
            generator.writeKey("policy_stats");
            generator.writeStartArray();
            for (IlmPolicyStatistics item0 : this.policyStats) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIlmDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::policyCount, JsonpDeserializer.integerDeserializer(), "policy_count");
        op.add(Builder::policyStats, JsonpDeserializer.arrayDeserializer(IlmPolicyStatistics._DESERIALIZER), "policy_stats");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Ilm> {
        private Integer policyCount;
        private List<IlmPolicyStatistics> policyStats;

        public final Builder policyCount(int value) {
            this.policyCount = value;
            return this;
        }

        public final Builder policyStats(List<IlmPolicyStatistics> list) {
            this.policyStats = Builder._listAddAll(this.policyStats, list);
            return this;
        }

        public final Builder policyStats(IlmPolicyStatistics value, IlmPolicyStatistics ... values) {
            this.policyStats = Builder._listAdd(this.policyStats, value, values);
            return this;
        }

        public final Builder policyStats(Function<IlmPolicyStatistics.Builder, ObjectBuilder<IlmPolicyStatistics>> fn) {
            return this.policyStats(fn.apply(new IlmPolicyStatistics.Builder()).build(), new IlmPolicyStatistics[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Ilm build() {
            this._checkSingleUse();
            return new Ilm(this);
        }
    }
}

