/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Vector
extends Base {
    private final int denseVectorDimsAvgCount;
    private final int denseVectorFieldsCount;
    @Nullable
    private final Integer sparseVectorFieldsCount;
    public static final JsonpDeserializer<Vector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Vector::setupVectorDeserializer);

    private Vector(Builder builder) {
        super(builder);
        this.denseVectorDimsAvgCount = ApiTypeHelper.requireNonNull(builder.denseVectorDimsAvgCount, this, "denseVectorDimsAvgCount");
        this.denseVectorFieldsCount = ApiTypeHelper.requireNonNull(builder.denseVectorFieldsCount, this, "denseVectorFieldsCount");
        this.sparseVectorFieldsCount = builder.sparseVectorFieldsCount;
    }

    public static Vector of(Function<Builder, ObjectBuilder<Vector>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int denseVectorDimsAvgCount() {
        return this.denseVectorDimsAvgCount;
    }

    public final int denseVectorFieldsCount() {
        return this.denseVectorFieldsCount;
    }

    @Nullable
    public final Integer sparseVectorFieldsCount() {
        return this.sparseVectorFieldsCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("dense_vector_dims_avg_count");
        generator.write(this.denseVectorDimsAvgCount);
        generator.writeKey("dense_vector_fields_count");
        generator.write(this.denseVectorFieldsCount);
        if (this.sparseVectorFieldsCount != null) {
            generator.writeKey("sparse_vector_fields_count");
            generator.write(this.sparseVectorFieldsCount);
        }
    }

    protected static void setupVectorDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::denseVectorDimsAvgCount, JsonpDeserializer.integerDeserializer(), "dense_vector_dims_avg_count");
        op.add(Builder::denseVectorFieldsCount, JsonpDeserializer.integerDeserializer(), "dense_vector_fields_count");
        op.add(Builder::sparseVectorFieldsCount, JsonpDeserializer.integerDeserializer(), "sparse_vector_fields_count");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Vector> {
        private Integer denseVectorDimsAvgCount;
        private Integer denseVectorFieldsCount;
        @Nullable
        private Integer sparseVectorFieldsCount;

        public final Builder denseVectorDimsAvgCount(int value) {
            this.denseVectorDimsAvgCount = value;
            return this;
        }

        public final Builder denseVectorFieldsCount(int value) {
            this.denseVectorFieldsCount = value;
            return this;
        }

        public final Builder sparseVectorFieldsCount(@Nullable Integer value) {
            this.sparseVectorFieldsCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Vector build() {
            this._checkSingleUse();
            return new Vector(this);
        }
    }
}

