/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.es;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.io.IOException;
import java.util.Map;
import org.apache.camel.component.es.ElasticsearchConfiguration;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class ElasticsearchComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    public ElasticsearchComponentVerifierExtension() {
        this("elasticsearch");
    }

    public ElasticsearchComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    @Override
    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption(parameters, "clusterName")).error(ResultErrorHelper.requiresOption(parameters, "hostAddresses"));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    @Override
    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.CONNECTIVITY);
        try {
            ElasticsearchConfiguration configuration = this.setProperties(new ElasticsearchConfiguration(), parameters);
            RestClientBuilder clientBuilder = RestClient.builder(configuration.getHostAddressesList().toArray(new HttpHost[0]));
            try (RestClientTransport transport = new RestClientTransport(clientBuilder.build(), new JacksonJsonpMapper());){
                ElasticsearchClient esClient = new ElasticsearchClient(transport);
                esClient.ping();
            }
        }
        catch (IOException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, e.getMessage()).detail("elasticsearch_exception_message", (Object)e.getMessage()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)e.getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            builder.error(errorBuilder.build());
        }
        catch (Exception e) {
            builder.error(ResultErrorBuilder.withException(e).build());
        }
        return builder.build();
    }
}

