/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.es.converter;

import co.elastic.clients.elasticsearch._types.WaitForActiveShards;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.MgetRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.CreateOperation;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateLoader=true)
public final class ElasticsearchActionRequestConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchActionRequestConverter.class);
    private static final String ES_QUERY_DSL_PREFIX = "query";

    private ElasticsearchActionRequestConverter() {
    }

    private static IndexOperation.Builder<?> createIndexOperationBuilder(Object document, Exchange exchange) throws IOException {
        if (document instanceof IndexOperation.Builder) {
            return (IndexOperation.Builder)document;
        }
        IndexOperation.Builder<Object> builder = new IndexOperation.Builder<Object>();
        if (document instanceof byte[]) {
            builder.document(JsonData.from(new ByteArrayInputStream((byte[])document)));
        } else if (document instanceof InputStream) {
            builder.document(JsonData.from((InputStream)document));
        } else if (document instanceof String) {
            builder.document(JsonData.from(new StringReader((String)document)));
        } else if (document instanceof Reader) {
            builder.document(JsonData.from((Reader)document));
        } else if (document instanceof Map) {
            ObjectMapper objectMapper = new ObjectMapper();
            builder.document(JsonData.from(new StringReader(objectMapper.writeValueAsString(document))));
        } else {
            builder.document(document);
        }
        return (IndexOperation.Builder)builder.index(exchange.getIn().getHeader("indexName", String.class));
    }

    @Converter
    public static IndexRequest.Builder<?> toIndexRequestBuilder(Object document, Exchange exchange) throws IOException {
        if (document instanceof IndexRequest.Builder) {
            IndexRequest.Builder builder = (IndexRequest.Builder)document;
            return builder.id(exchange.getIn().getHeader("indexId", String.class));
        }
        IndexRequest.Builder<Object> builder = new IndexRequest.Builder<Object>();
        if (document instanceof byte[]) {
            builder.withJson(new ByteArrayInputStream((byte[])document));
        } else if (document instanceof InputStream) {
            builder.withJson((InputStream)document);
        } else if (document instanceof String) {
            builder.withJson(new StringReader((String)document));
        } else if (document instanceof Reader) {
            builder.withJson((Reader)document);
        } else if (document instanceof Map) {
            ObjectMapper objectMapper = new ObjectMapper();
            builder.withJson(new StringReader(objectMapper.writeValueAsString(document)));
        } else {
            builder.document(document);
        }
        return builder.waitForActiveShards(new WaitForActiveShards.Builder().count(exchange.getIn().getHeader("waitForActiveShards", Integer.class)).build()).id(exchange.getIn().getHeader("indexId", String.class)).index(exchange.getIn().getHeader("indexName", String.class));
    }

    @Converter
    public static UpdateRequest.Builder<?, ?> toUpdateRequestBuilder(Object document, Exchange exchange) throws IOException {
        Mode mode;
        if (document instanceof UpdateRequest.Builder) {
            UpdateRequest.Builder builder = (UpdateRequest.Builder)document;
            return builder.id(exchange.getIn().getHeader("indexId", String.class));
        }
        UpdateRequest.Builder builder = new UpdateRequest.Builder();
        Boolean enableDocumentOnlyMode = exchange.getIn().getHeader("enableDocumentOnlyMode", Boolean.FALSE, Boolean.class);
        Mode mode2 = mode = enableDocumentOnlyMode == Boolean.TRUE ? Mode.DOCUMENT_ONLY : Mode.DEFAULT;
        if (document instanceof byte[]) {
            mode.addDocToUpdateRequestBuilder(builder, new ByteArrayInputStream((byte[])document));
        } else if (document instanceof InputStream) {
            mode.addDocToUpdateRequestBuilder(builder, (InputStream)document);
        } else if (document instanceof String) {
            mode.addDocToUpdateRequestBuilder(builder, new StringReader((String)document));
        } else if (document instanceof Reader) {
            mode.addDocToUpdateRequestBuilder(builder, (Reader)document);
        } else if (document instanceof Map) {
            ObjectMapper objectMapper = new ObjectMapper();
            mode.addDocToUpdateRequestBuilder(builder, new StringReader(objectMapper.writeValueAsString(document)));
        } else {
            builder.doc(document);
        }
        return builder.waitForActiveShards(new WaitForActiveShards.Builder().count(exchange.getIn().getHeader("waitForActiveShards", Integer.class)).build()).index(exchange.getIn().getHeader("indexName", String.class)).id(exchange.getIn().getHeader("indexId", String.class));
    }

    @Converter
    public static GetRequest.Builder toGetRequestBuilder(Object document, Exchange exchange) {
        if (document instanceof GetRequest.Builder) {
            return (GetRequest.Builder)document;
        }
        if (document instanceof String) {
            return new GetRequest.Builder().index(exchange.getIn().getHeader("indexName", String.class)).id((String)document);
        }
        return null;
    }

    @Converter
    public static DeleteRequest.Builder toDeleteRequestBuilder(Object document, Exchange exchange) {
        if (document instanceof DeleteRequest.Builder) {
            return (DeleteRequest.Builder)document;
        }
        if (document instanceof String) {
            return new DeleteRequest.Builder().index(exchange.getIn().getHeader("indexName", String.class)).id((String)document);
        }
        return null;
    }

    @Converter
    public static DeleteIndexRequest.Builder toDeleteIndexRequestBuilder(Object document, Exchange exchange) {
        if (document instanceof DeleteIndexRequest.Builder) {
            return (DeleteIndexRequest.Builder)document;
        }
        if (document instanceof String) {
            return new DeleteIndexRequest.Builder().index(exchange.getIn().getHeader("indexName", String.class), new String[0]);
        }
        return null;
    }

    @Converter
    public static MgetRequest.Builder toMgetRequestBuilder(Object documents, Exchange exchange) {
        if (documents instanceof MgetRequest.Builder) {
            return (MgetRequest.Builder)documents;
        }
        if (documents instanceof Iterable) {
            MgetRequest.Builder builder = new MgetRequest.Builder();
            builder.index(exchange.getIn().getHeader("indexName", String.class));
            for (Object document : (List)documents) {
                if (document instanceof String) {
                    builder.ids((String)document, new String[0]);
                    continue;
                }
                LOG.warn("Cannot convert document id of type {} into a String", (Object)(document == null ? "null" : document.getClass().getName()));
                return null;
            }
            return builder;
        }
        return null;
    }

    @Converter
    public static SearchRequest.Builder toSearchRequestBuilder(Object queryObject, Exchange exchange) throws IOException {
        String queryText;
        String indexName = exchange.getIn().getHeader("indexName", String.class);
        if (queryObject instanceof SearchRequest.Builder) {
            SearchRequest.Builder builder = (SearchRequest.Builder)queryObject;
            if (builder.build().index().isEmpty()) {
                builder.index(indexName, new String[0]);
            }
            return builder;
        }
        SearchRequest.Builder builder = new SearchRequest.Builder();
        Integer size = exchange.getIn().getHeader("size", Integer.class);
        Integer from = exchange.getIn().getHeader("from", Integer.class);
        if (ObjectHelper.isNotEmpty(indexName)) {
            builder.index(indexName, new String[0]);
        }
        if (queryObject instanceof Map) {
            Map mapQuery = (Map)queryObject;
            if (mapQuery.containsKey(ES_QUERY_DSL_PREFIX)) {
                mapQuery = (Map)mapQuery.get(ES_QUERY_DSL_PREFIX);
            }
            ObjectMapper objectMapper = new ObjectMapper();
            queryText = objectMapper.writeValueAsString(mapQuery);
        } else if (queryObject instanceof String) {
            ObjectMapper mapper = new ObjectMapper();
            queryText = (String)queryObject;
            JsonNode jsonTextObject = mapper.readValue(queryText, JsonNode.class);
            JsonNode parentJsonNode = jsonTextObject.get(ES_QUERY_DSL_PREFIX);
            if (parentJsonNode != null) {
                queryText = parentJsonNode.toString();
            }
        } else {
            LOG.warn("Cannot convert queryObject of type {} into SearchRequest object", (Object)(queryObject == null ? "null" : queryObject.getClass().getName()));
            return null;
        }
        if (size != null) {
            builder.size(size);
        }
        if (from != null) {
            builder.from(from);
        }
        builder.query(((Query.Builder)new Query.Builder().withJson(new StringReader(queryText))).build());
        return builder;
    }

    @Converter
    public static BulkRequest.Builder toBulkRequestBuilder(Object documents, Exchange exchange) throws IOException {
        if (documents instanceof BulkRequest.Builder) {
            return (BulkRequest.Builder)documents;
        }
        if (documents instanceof Iterable) {
            BulkRequest.Builder builder = new BulkRequest.Builder();
            builder.index(exchange.getIn().getHeader("indexName", String.class));
            for (Object document : (List)documents) {
                if (document instanceof DeleteOperation.Builder) {
                    builder.operations(new BulkOperation.Builder().delete(((DeleteOperation.Builder)document).build()).build(), new BulkOperation[0]);
                    continue;
                }
                if (document instanceof UpdateOperation.Builder) {
                    builder.operations(new BulkOperation.Builder().update(((UpdateOperation.Builder)document).build()).build(), new BulkOperation[0]);
                    continue;
                }
                if (document instanceof CreateOperation.Builder) {
                    builder.operations(new BulkOperation.Builder().create(((CreateOperation.Builder)document).build()).build(), new BulkOperation[0]);
                    continue;
                }
                builder.operations(new BulkOperation.Builder().index(ElasticsearchActionRequestConverter.createIndexOperationBuilder(document, exchange).build()).build(), new BulkOperation[0]);
            }
            return builder;
        }
        return null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Mode {
        DEFAULT{

            @Override
            protected void addDocToUpdateRequestBuilder(UpdateRequest.Builder<?, Object> builder, InputStream in) {
                builder.withJson(in);
            }

            @Override
            protected void addDocToUpdateRequestBuilder(UpdateRequest.Builder<?, Object> builder, Reader in) {
                builder.withJson(in);
            }
        }
        ,
        DOCUMENT_ONLY{

            @Override
            protected void addDocToUpdateRequestBuilder(UpdateRequest.Builder<?, Object> builder, InputStream in) {
                builder.doc(JsonData.from(in));
            }

            @Override
            protected void addDocToUpdateRequestBuilder(UpdateRequest.Builder<?, Object> builder, Reader in) {
                builder.doc(JsonData.from(in));
            }
        };


        protected abstract void addDocToUpdateRequestBuilder(UpdateRequest.Builder<?, Object> var1, InputStream var2);

        protected abstract void addDocToUpdateRequestBuilder(UpdateRequest.Builder<?, Object> var1, Reader var2);
    }
}

