/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.DataStreamVisibility;
import co.elastic.clients.elasticsearch.indices.SimulateTemplateResponse;
import co.elastic.clients.elasticsearch.indices.put_index_template.IndexTemplateMapping;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SimulateTemplateRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean allowAutoCreate;
    private final List<String> composedOf;
    @Nullable
    private final Boolean create;
    @Nullable
    private final DataStreamVisibility dataStream;
    @Nullable
    private final Boolean deprecated;
    private final List<String> ignoreMissingComponentTemplates;
    @Nullable
    private final Boolean includeDefaults;
    private final List<String> indexPatterns;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String name;
    @Nullable
    private final Long priority;
    @Nullable
    private final IndexTemplateMapping template;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<SimulateTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimulateTemplateRequest::setupSimulateTemplateRequestDeserializer);
    public static final Endpoint<SimulateTemplateRequest, SimulateTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SimulateTemplateRequest, SimulateTemplateResponse>("es/indices.simulate_template", request -> "POST", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_index_template");
            buf.append("/_simulate");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_index_template");
            buf.append("/_simulate");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.create != null) {
            params.put("create", String.valueOf(request.create));
        }
        if (request.includeDefaults != null) {
            params.put("include_defaults", String.valueOf(request.includeDefaults));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, SimulateTemplateResponse._DESERIALIZER);

    private SimulateTemplateRequest(Builder builder) {
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.allowAutoCreate = builder.allowAutoCreate;
        this.composedOf = ApiTypeHelper.unmodifiable(builder.composedOf);
        this.create = builder.create;
        this.dataStream = builder.dataStream;
        this.deprecated = builder.deprecated;
        this.ignoreMissingComponentTemplates = ApiTypeHelper.unmodifiable(builder.ignoreMissingComponentTemplates);
        this.includeDefaults = builder.includeDefaults;
        this.indexPatterns = ApiTypeHelper.unmodifiable(builder.indexPatterns);
        this.masterTimeout = builder.masterTimeout;
        this.name = builder.name;
        this.priority = builder.priority;
        this.template = builder.template;
        this.version = builder.version;
    }

    public static SimulateTemplateRequest of(Function<Builder, ObjectBuilder<SimulateTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Boolean allowAutoCreate() {
        return this.allowAutoCreate;
    }

    public final List<String> composedOf() {
        return this.composedOf;
    }

    @Nullable
    public final Boolean create() {
        return this.create;
    }

    @Nullable
    public final DataStreamVisibility dataStream() {
        return this.dataStream;
    }

    @Nullable
    public final Boolean deprecated() {
        return this.deprecated;
    }

    public final List<String> ignoreMissingComponentTemplates() {
        return this.ignoreMissingComponentTemplates;
    }

    @Nullable
    public final Boolean includeDefaults() {
        return this.includeDefaults;
    }

    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Long priority() {
        return this.priority;
    }

    @Nullable
    public final IndexTemplateMapping template() {
        return this.template;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.allowAutoCreate != null) {
            generator.writeKey("allow_auto_create");
            generator.write(this.allowAutoCreate);
        }
        if (ApiTypeHelper.isDefined(this.composedOf)) {
            generator.writeKey("composed_of");
            generator.writeStartArray();
            for (String string : this.composedOf) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.dataStream != null) {
            generator.writeKey("data_stream");
            this.dataStream.serialize(generator, mapper);
        }
        if (this.deprecated != null) {
            generator.writeKey("deprecated");
            generator.write(this.deprecated);
        }
        if (ApiTypeHelper.isDefined(this.ignoreMissingComponentTemplates)) {
            generator.writeKey("ignore_missing_component_templates");
            generator.writeStartArray();
            for (String string : this.ignoreMissingComponentTemplates) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indexPatterns)) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String string : this.indexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority);
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
    }

    protected static void setupSimulateTemplateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::allowAutoCreate, JsonpDeserializer.booleanDeserializer(), "allow_auto_create");
        op.add(Builder::composedOf, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "composed_of");
        op.add(Builder::dataStream, DataStreamVisibility._DESERIALIZER, "data_stream");
        op.add(Builder::deprecated, JsonpDeserializer.booleanDeserializer(), "deprecated");
        op.add(Builder::ignoreMissingComponentTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ignore_missing_component_templates");
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
        op.add(Builder::priority, JsonpDeserializer.longDeserializer(), "priority");
        op.add(Builder::template, IndexTemplateMapping._DESERIALIZER, "template");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SimulateTemplateRequest> {
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean allowAutoCreate;
        @Nullable
        private List<String> composedOf;
        @Nullable
        private Boolean create;
        @Nullable
        private DataStreamVisibility dataStream;
        @Nullable
        private Boolean deprecated;
        @Nullable
        private List<String> ignoreMissingComponentTemplates;
        @Nullable
        private Boolean includeDefaults;
        @Nullable
        private List<String> indexPatterns;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String name;
        @Nullable
        private Long priority;
        @Nullable
        private IndexTemplateMapping template;
        @Nullable
        private Long version;

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder allowAutoCreate(@Nullable Boolean value) {
            this.allowAutoCreate = value;
            return this;
        }

        public final Builder composedOf(List<String> list) {
            this.composedOf = Builder._listAddAll(this.composedOf, list);
            return this;
        }

        public final Builder composedOf(String value, String ... values) {
            this.composedOf = Builder._listAdd(this.composedOf, value, values);
            return this;
        }

        public final Builder create(@Nullable Boolean value) {
            this.create = value;
            return this;
        }

        public final Builder dataStream(@Nullable DataStreamVisibility value) {
            this.dataStream = value;
            return this;
        }

        public final Builder dataStream(Function<DataStreamVisibility.Builder, ObjectBuilder<DataStreamVisibility>> fn) {
            return this.dataStream(fn.apply(new DataStreamVisibility.Builder()).build());
        }

        public final Builder deprecated(@Nullable Boolean value) {
            this.deprecated = value;
            return this;
        }

        public final Builder ignoreMissingComponentTemplates(List<String> list) {
            this.ignoreMissingComponentTemplates = Builder._listAddAll(this.ignoreMissingComponentTemplates, list);
            return this;
        }

        public final Builder ignoreMissingComponentTemplates(String value, String ... values) {
            this.ignoreMissingComponentTemplates = Builder._listAdd(this.ignoreMissingComponentTemplates, value, values);
            return this;
        }

        public final Builder includeDefaults(@Nullable Boolean value) {
            this.includeDefaults = value;
            return this;
        }

        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder priority(@Nullable Long value) {
            this.priority = value;
            return this;
        }

        public final Builder template(@Nullable IndexTemplateMapping value) {
            this.template = value;
            return this;
        }

        public final Builder template(Function<IndexTemplateMapping.Builder, ObjectBuilder<IndexTemplateMapping>> fn) {
            return this.template(fn.apply(new IndexTemplateMapping.Builder()).build());
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SimulateTemplateRequest build() {
            this._checkSingleUse();
            return new SimulateTemplateRequest(this);
        }
    }
}

