/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceConfigCreate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigCreateVariant;
import co.elastic.clients.elasticsearch.ml.TokenizationConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TextEmbeddingInferenceOptions
implements InferenceConfigCreateVariant,
JsonpSerializable {
    @Nullable
    private final Integer embeddingSize;
    @Nullable
    private final TokenizationConfig tokenization;
    @Nullable
    private final String resultsField;
    public static final JsonpDeserializer<TextEmbeddingInferenceOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextEmbeddingInferenceOptions::setupTextEmbeddingInferenceOptionsDeserializer);

    private TextEmbeddingInferenceOptions(Builder builder) {
        this.embeddingSize = builder.embeddingSize;
        this.tokenization = builder.tokenization;
        this.resultsField = builder.resultsField;
    }

    public static TextEmbeddingInferenceOptions of(Function<Builder, ObjectBuilder<TextEmbeddingInferenceOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfigCreate.Kind _inferenceConfigCreateKind() {
        return InferenceConfigCreate.Kind.TextEmbedding;
    }

    @Nullable
    public final Integer embeddingSize() {
        return this.embeddingSize;
    }

    @Nullable
    public final TokenizationConfig tokenization() {
        return this.tokenization;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.embeddingSize != null) {
            generator.writeKey("embedding_size");
            generator.write(this.embeddingSize);
        }
        if (this.tokenization != null) {
            generator.writeKey("tokenization");
            this.tokenization.serialize(generator, mapper);
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTextEmbeddingInferenceOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::embeddingSize, JsonpDeserializer.integerDeserializer(), "embedding_size");
        op.add(Builder::tokenization, TokenizationConfig._DESERIALIZER, "tokenization");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TextEmbeddingInferenceOptions> {
        @Nullable
        private Integer embeddingSize;
        @Nullable
        private TokenizationConfig tokenization;
        @Nullable
        private String resultsField;

        public final Builder embeddingSize(@Nullable Integer value) {
            this.embeddingSize = value;
            return this;
        }

        public final Builder tokenization(@Nullable TokenizationConfig value) {
            this.tokenization = value;
            return this;
        }

        public final Builder tokenization(Function<TokenizationConfig.Builder, ObjectBuilder<TokenizationConfig>> fn) {
            return this.tokenization(fn.apply(new TokenizationConfig.Builder()).build());
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextEmbeddingInferenceOptions build() {
            this._checkSingleUse();
            return new TextEmbeddingInferenceOptions(this);
        }
    }
}

