/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.search_application;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.search_application.PutResponse;
import co.elastic.clients.elasticsearch.search_application.SearchApplication;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean create;
    private final String name;
    private final SearchApplication searchApplication;
    public static final JsonpDeserializer<PutRequest> _DESERIALIZER = PutRequest.createPutRequestDeserializer();
    public static final Endpoint<PutRequest, PutResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutRequest, PutResponse>("es/search_application.put", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_application");
            buf.append("/search_application");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.create != null) {
            params.put("create", String.valueOf(request.create));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutResponse._DESERIALIZER);

    private PutRequest(Builder builder) {
        this.create = builder.create;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.searchApplication = ApiTypeHelper.requireNonNull(builder.searchApplication, this, "searchApplication");
    }

    public static PutRequest of(Function<Builder, ObjectBuilder<PutRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean create() {
        return this.create;
    }

    public final String name() {
        return this.name;
    }

    public final SearchApplication searchApplication() {
        return this.searchApplication;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.searchApplication.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<PutRequest> createPutRequestDeserializer() {
        JsonpDeserializer<SearchApplication> valueDeserializer = SearchApplication._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().searchApplication((SearchApplication)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)((Object)event))).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutRequest> {
        @Nullable
        private Boolean create;
        private String name;
        private SearchApplication searchApplication;

        public final Builder create(@Nullable Boolean value) {
            this.create = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder searchApplication(SearchApplication value) {
            this.searchApplication = value;
            return this;
        }

        public final Builder searchApplication(Function<SearchApplication.Builder, ObjectBuilder<SearchApplication>> fn) {
            return this.searchApplication(fn.apply(new SearchApplication.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            SearchApplication value = SearchApplication._DESERIALIZER.deserialize(parser, mapper);
            return this.searchApplication(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutRequest build() {
            this._checkSingleUse();
            return new PutRequest(this);
        }
    }
}

