/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.HasPrivilegesUserProfileResponse;
import co.elastic.clients.elasticsearch.security.has_privileges_user_profile.PrivilegesCheck;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class HasPrivilegesUserProfileRequest
extends RequestBase
implements JsonpSerializable {
    private final PrivilegesCheck privileges;
    private final List<String> uids;
    public static final JsonpDeserializer<HasPrivilegesUserProfileRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HasPrivilegesUserProfileRequest::setupHasPrivilegesUserProfileRequestDeserializer);
    public static final Endpoint<HasPrivilegesUserProfileRequest, HasPrivilegesUserProfileResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<HasPrivilegesUserProfileRequest, HasPrivilegesUserProfileResponse>("es/security.has_privileges_user_profile", request -> "POST", request -> "/_security/profile/_has_privileges", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, HasPrivilegesUserProfileResponse._DESERIALIZER);

    private HasPrivilegesUserProfileRequest(Builder builder) {
        this.privileges = ApiTypeHelper.requireNonNull(builder.privileges, this, "privileges");
        this.uids = ApiTypeHelper.unmodifiableRequired(builder.uids, (Object)this, "uids");
    }

    public static HasPrivilegesUserProfileRequest of(Function<Builder, ObjectBuilder<HasPrivilegesUserProfileRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final PrivilegesCheck privileges() {
        return this.privileges;
    }

    public final List<String> uids() {
        return this.uids;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("privileges");
        this.privileges.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.uids)) {
            generator.writeKey("uids");
            generator.writeStartArray();
            for (String item0 : this.uids) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupHasPrivilegesUserProfileRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::privileges, PrivilegesCheck._DESERIALIZER, "privileges");
        op.add(Builder::uids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "uids");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HasPrivilegesUserProfileRequest> {
        private PrivilegesCheck privileges;
        private List<String> uids;

        public final Builder privileges(PrivilegesCheck value) {
            this.privileges = value;
            return this;
        }

        public final Builder privileges(Function<PrivilegesCheck.Builder, ObjectBuilder<PrivilegesCheck>> fn) {
            return this.privileges(fn.apply(new PrivilegesCheck.Builder()).build());
        }

        public final Builder uids(List<String> list) {
            this.uids = Builder._listAddAll(this.uids, list);
            return this;
        }

        public final Builder uids(String value, String ... values) {
            this.uids = Builder._listAdd(this.uids, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HasPrivilegesUserProfileRequest build() {
            this._checkSingleUse();
            return new HasPrivilegesUserProfileRequest(this);
        }
    }
}

