/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.common;

import io.undertow.server.session.SessionManager;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.infinispan.Cache;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.wildfly.elytron.web.undertow.common.AbstractHttpServerMechanismTest;
import org.wildfly.elytron.web.undertow.common.KeyPairSupplier;
import org.wildfly.elytron.web.undertow.common.UndertowServer;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.sso.DefaultSingleSignOnManager;
import org.wildfly.security.http.util.sso.DefaultSingleSignOnSessionFactory;
import org.wildfly.security.http.util.sso.DefaultSingleSignOnSessionIdentifierFactory;
import org.wildfly.security.http.util.sso.SingleSignOnEntry;
import org.wildfly.security.http.util.sso.SingleSignOnServerMechanismFactory;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.permission.PermissionVerifier;

public abstract class FormAuthenticationWithClusteredSSOBase
extends AbstractHttpServerMechanismTest {
    protected final Map<Integer, SessionManager> sessionManagers = new HashMap<Integer, SessionManager>();
    private final Supplier<KeyPair> keyPairSupplier = new KeyPairSupplier();
    @Rule
    public final UndertowServer serverA = this.createUndertowServer(7776);
    @Rule
    public final UndertowServer serverB = this.createUndertowServer(7777);
    @Rule
    public final UndertowServer serverC = this.createUndertowServer(7778);
    @Rule
    public final UndertowServer serverD = this.createUndertowServer(7779);
    @Rule
    public final UndertowServer serverE = this.createUndertowServer(7780);

    protected FormAuthenticationWithClusteredSSOBase() throws Exception {
    }

    @Test
    public void testSingleSignOn() throws Exception {
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCookieStore(cookieStore).setRedirectStrategy(new LaxRedirectStrategy()).build();
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverA.createUri())));
        Assert.assertFalse((boolean)cookieStore.getCookies().stream().filter(cookie -> cookie.getName().equals("JSESSIONSSOID")).findAny().isPresent());
        HttpPost httpAuthenticate = new HttpPost(this.serverA.createUri("/j_security_check"));
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(2);
        parameters.add(new BasicNameValuePair("j_username", "ladybird"));
        parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
        httpAuthenticate.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
        HttpResponse execute = httpClient.execute(httpAuthenticate);
        Assert.assertTrue((boolean)cookieStore.getCookies().stream().filter(cookie -> cookie.getName().equals("JSESSIONSSOID")).findAny().isPresent());
        this.assertSuccessfulResponse(execute, "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverB.createUri())), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverC.createUri())), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverD.createUri())), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverE.createUri())), "ladybird");
    }

    @Test
    public void testSingleLogout() throws Exception {
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCookieStore(cookieStore).setRedirectStrategy(new LaxRedirectStrategy()).build();
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverA.createUri())));
        HttpPost httpAuthenticate = new HttpPost(this.serverA.createUri("/j_security_check"));
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("j_username", "ladybird"));
        parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
        httpAuthenticate.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
        HttpResponse execute = httpClient.execute(httpAuthenticate);
        this.assertSuccessfulResponse(execute, "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverB.createUri())), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverC.createUri())), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverD.createUri())), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverE.createUri())), "ladybird");
        httpClient.execute(new HttpGet(this.serverB.createUri("/logout")));
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverC.createUri())));
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverA.createUri())));
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverB.createUri())));
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverD.createUri())));
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverE.createUri())));
    }

    @Test
    public void testSingleLogoutWhenNodeIsFailing() throws Exception {
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCookieStore(cookieStore).setRedirectStrategy(new LaxRedirectStrategy()).build();
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverA.createUri())));
        HttpPost httpAuthenticate = new HttpPost(this.serverA.createUri("/j_security_check"));
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(2);
        parameters.add(new BasicNameValuePair("j_username", "ladybird"));
        parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
        httpAuthenticate.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
        HttpResponse execute = httpClient.execute(httpAuthenticate);
        this.assertSuccessfulResponse(execute, "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverB.createUri())), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverC.createUri())), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverD.createUri())), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverE.createUri())), "ladybird");
        this.serverC.forceShutdown();
        this.serverE.forceShutdown();
        httpClient.execute(new HttpGet(this.serverB.createUri("/logout")));
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverA.createUri())));
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverB.createUri())));
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverD.createUri())));
    }

    @Test
    public void testSessionInvalidation() throws Exception {
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCookieStore(cookieStore).setRedirectStrategy(new LaxRedirectStrategy()).build();
        FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverA.createUri())));
        for (int i = 0; i < 10; ++i) {
            HttpPost httpAuthenticate = new HttpPost(this.serverA.createUri("/j_security_check"));
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(2);
            parameters.add(new BasicNameValuePair("j_username", "ladybird"));
            parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
            httpAuthenticate.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
            HttpResponse execute = httpClient.execute(httpAuthenticate);
            this.assertSuccessfulResponse(execute, "ladybird");
            this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverA.createUri())), "ladybird");
            this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverB.createUri())), "ladybird");
            this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverC.createUri())), "ladybird");
            this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverD.createUri())), "ladybird");
            this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.serverE.createUri())), "ladybird");
            httpClient.execute(new HttpGet(this.serverA.createUri("/logout")));
            FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverC.createUri())));
            FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverA.createUri())));
            FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverB.createUri())));
            FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverD.createUri())));
            FormAuthenticationWithClusteredSSOBase.assertLoginPage(httpClient.execute(new HttpGet(this.serverE.createUri())));
        }
        this.sessionManagers.values().forEach(manager -> Assert.assertEquals((String)manager.getDeploymentName(), (long)1L, (long)manager.getActiveSessions().size()));
    }

    @Override
    protected String getMechanismName() {
        return "FORM";
    }

    @Override
    protected SecurityDomain doCreateSecurityDomain() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance("clear");
        HashMap<String, SimpleRealmEntry> passwordMap = new HashMap<String, SimpleRealmEntry>();
        passwordMap.put("ladybird", new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(passwordFactory.generatePassword(new ClearPasswordSpec("Coleoptera".toCharArray()))))));
        SimpleMapBackedSecurityRealm securityRealm = new SimpleMapBackedSecurityRealm();
        securityRealm.setPasswordMap(passwordMap);
        SecurityDomain.Builder builder = SecurityDomain.builder().setDefaultRealmName("TestRealm");
        builder.addRealm("TestRealm", securityRealm).build();
        builder.setPermissionMapper((principal, roles) -> PermissionVerifier.from(new LoginPermission()));
        return builder.build();
    }

    @Override
    protected HttpServerAuthenticationMechanismFactory getHttpServerAuthenticationMechanismFactory(Map<String, ?> properties) {
        HttpServerAuthenticationMechanismFactory delegate = super.getHttpServerAuthenticationMechanismFactory(properties);
        String cacheManagerName = UUID.randomUUID().toString();
        ClassAllowList allowList = new ClassAllowList();
        allowList.addRegexps(new String[]{".*"});
        DefaultCacheManager cacheManager = new DefaultCacheManager(GlobalConfigurationBuilder.defaultClusteredBuilder().globalJmxStatistics().cacheManagerName(cacheManagerName).defaultCacheName("Default").transport().nodeName(cacheManagerName).addProperty("configurationFile", (Object)"fast.xml").serialization().marshaller((Marshaller)new JavaSerializationMarshaller(allowList)).build(), new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).build());
        Cache cache = cacheManager.getCache();
        DefaultSingleSignOnManager manager = new DefaultSingleSignOnManager((ConcurrentMap<String, SingleSignOnEntry>)cache, new DefaultSingleSignOnSessionIdentifierFactory(), (id, entry) -> cache.put(id, entry));
        SingleSignOnServerMechanismFactory.SingleSignOnConfiguration signOnConfiguration = new SingleSignOnServerMechanismFactory.SingleSignOnConfiguration("JSESSIONSSOID", null, "/", false, false);
        DefaultSingleSignOnSessionFactory singleSignOnSessionFactory = new DefaultSingleSignOnSessionFactory(manager, this.keyPairSupplier.get());
        return new SingleSignOnServerMechanismFactory(delegate, (SingleSignOnSessionFactory)singleSignOnSessionFactory, signOnConfiguration);
    }

    protected abstract UndertowServer createUndertowServer(int var1) throws Exception;
}

