/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.handlers.AbstractSecurityContextAssociationHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.elytron.web.undertow.server.SecurityContextImpl;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;

public class ElytronContextAssociationHandler
extends AbstractSecurityContextAssociationHandler {
    private final String programmaticMechanismName;
    private final SecurityDomain securityDomain;
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private final Function<HttpServerExchange, ElytronHttpExchange> httpExchangeSupplier;
    private final BiFunction<HttpExchangeSpi, String, IdentityCache> identityCacheSupplier;
    private final AuthenticationMode authenticationMode;

    protected ElytronContextAssociationHandler(Builder builder) {
        super(Assert.checkNotNullParam("next", builder.next));
        this.programmaticMechanismName = builder.programmaticMechanismName != null ? builder.programmaticMechanismName : "Programmatic";
        this.securityDomain = builder.securityDomain;
        this.mechanismSupplier = Assert.checkNotNullParam("mechanismSupplier", builder.mechanismSupplier);
        this.httpExchangeSupplier = Assert.checkNotNullParam("httpExchangeSupplier", builder.httpExchangeSupplier);
        this.identityCacheSupplier = builder.identityCacheSupplier;
        this.authenticationMode = builder.authenticationMode;
    }

    @Override
    public SecurityContext createSecurityContext(HttpServerExchange exchange) {
        return this.populateSecurityContextBuilder(SecurityContextImpl.builder(), exchange).build();
    }

    protected SecurityContextImpl.Builder populateSecurityContextBuilder(SecurityContextImpl.Builder builder, HttpServerExchange exchange) {
        ElytronHttpExchange httpExchange = this.httpExchangeSupplier.apply(exchange);
        return builder.setExchange(exchange).setProgrammaticMechanismName(this.programmaticMechanismName).setSecurityDomain(this.securityDomain).setMechanismSupplier(this.mechanismSupplier).setAuthMode(this.authenticationMode).setHttpExchange(httpExchange).setIdentityCacheSupplier(this.identityCacheSupplier != null ? () -> this.identityCacheSupplier.apply(httpExchange, this.programmaticMechanismName) : null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        HttpHandler next;
        String programmaticMechanismName;
        SecurityDomain securityDomain;
        Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
        Function<HttpServerExchange, ElytronHttpExchange> httpExchangeSupplier = ElytronHttpExchange::new;
        BiFunction<HttpExchangeSpi, String, IdentityCache> identityCacheSupplier;
        AuthenticationMode authenticationMode;

        protected Builder() {
        }

        public Builder setNext(HttpHandler next) {
            this.next = next;
            return this;
        }

        @Deprecated
        public Builder setProgramaticMechanismName(String programmaticMechanismName) {
            return this.setProgrammaticMechanismName(programmaticMechanismName);
        }

        public Builder setProgrammaticMechanismName(String programmaticMechanismName) {
            this.programmaticMechanismName = programmaticMechanismName;
            return this;
        }

        public Builder setSecurityDomain(SecurityDomain securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder setMechanismSupplier(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
            this.mechanismSupplier = mechanismSupplier;
            return this;
        }

        public Builder setHttpExchangeSupplier(Function<HttpServerExchange, ElytronHttpExchange> httpExchangeSupplier) {
            this.httpExchangeSupplier = httpExchangeSupplier;
            return this;
        }

        public Builder setAuthenticationMode(AuthenticationMode authMode) {
            this.authenticationMode = authMode;
            return this;
        }

        public Builder setIdentityCacheSupplier(BiFunction<HttpExchangeSpi, String, IdentityCache> identityCacheSupplier) {
            this.identityCacheSupplier = identityCacheSupplier;
            return this;
        }

        public HttpHandler build() {
            return new ElytronContextAssociationHandler(this);
        }
    }
}

