/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.ElytronMessages;
import org.wildfly.security.audit.EventPriority;

public class FileAuditEndpoint
implements AuditEndpoint {
    private static final String LINE_TERMINATOR = System.lineSeparator();
    private volatile boolean accepting = true;
    private final Supplier<DateTimeFormatter> dateTimeFormatterSupplier;
    private final boolean syncOnAccept;
    private final boolean flushOnAccept;
    private File file;
    private FileDescriptor fileDescriptor;
    private Writer writer;
    private Charset charset;
    protected final Clock clock;

    FileAuditEndpoint(Builder builder) throws IOException {
        this.dateTimeFormatterSupplier = builder.dateTimeFormatterSupplier;
        this.syncOnAccept = builder.syncOnAccept;
        this.flushOnAccept = builder.flushOnAccept;
        this.clock = builder.clock;
        this.charset = builder.charset != null ? builder.charset : StandardCharsets.UTF_8;
        this.setFile(builder.location.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFile(File file) throws IOException {
        boolean ok = false;
        FileOutputStream fos = new FileOutputStream(file, true);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fos), this.charset);
            try {
                this.fileDescriptor = fos.getFD();
                this.writer = writer;
                this.file = file;
                ok = true;
            }
            finally {
                if (!ok) {
                    this.safeClose(writer);
                }
            }
        }
        finally {
            if (!ok) {
                this.safeClose(fos);
            }
        }
    }

    File getFile() {
        return this.file;
    }

    private void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            ElytronMessages.audit.trace("Unable to close", e);
        }
    }

    void write(String toWrite) throws IOException {
        this.writer.write(toWrite);
    }

    void preWrite(Instant instant) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(EventPriority priority, String message) throws IOException {
        if (!this.accepting) {
            return;
        }
        Instant instant = this.clock.instant();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.dateTimeFormatterSupplier.get().format(instant));
        buffer.append(',');
        buffer.append(priority.toString());
        buffer.append(',');
        buffer.append(message);
        buffer.append(LINE_TERMINATOR);
        String toWrite = buffer.toString();
        FileAuditEndpoint fileAuditEndpoint = this;
        synchronized (fileAuditEndpoint) {
            if (!this.accepting) {
                return;
            }
            this.preWrite(instant);
            this.write(toWrite);
            if (this.flushOnAccept) {
                this.writer.flush();
            }
            if (this.syncOnAccept) {
                this.fileDescriptor.sync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.accepting = false;
        FileAuditEndpoint fileAuditEndpoint = this;
        synchronized (fileAuditEndpoint) {
            this.closeStreams();
        }
    }

    void closeStreams() throws IOException {
        this.writer.flush();
        this.fileDescriptor.sync();
        this.writer.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Clock clock = Clock.systemUTC();
        private Supplier<DateTimeFormatter> dateTimeFormatterSupplier = () -> DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault());
        private Path location = new File("audit.log").toPath();
        private boolean syncOnAccept = true;
        private boolean flushOnAccept = true;
        private boolean flushSet = false;
        private Charset charset;

        Builder() {
        }

        public Builder setDateTimeFormatterSupplier(Supplier<DateTimeFormatter> dateTimeFormatterSupplier) {
            this.dateTimeFormatterSupplier = Assert.checkNotNullParam("dateTimeFormatterSupplier", dateTimeFormatterSupplier);
            return this;
        }

        public Builder setLocation(Path location) {
            this.location = Assert.checkNotNullParam("location", location);
            return this;
        }

        public Builder setFlushOnAccept(boolean flushOnAccept) {
            this.flushOnAccept = flushOnAccept;
            this.flushSet = true;
            return this;
        }

        public Builder setSyncOnAccept(boolean syncOnAccept) {
            this.syncOnAccept = syncOnAccept;
            if (!this.flushSet) {
                this.flushOnAccept = syncOnAccept;
            }
            return this;
        }

        Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public AuditEndpoint build() throws IOException {
            return new FileAuditEndpoint(this);
        }
    }
}

