/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcClientConfigurationBuilder;
import org.wildfly.security.http.oidc.OidcClientConfigurationResolver;
import org.wildfly.security.http.oidc.OidcClientContext;

public class OidcConfigurationServletListener
implements ServletContextListener {
    @Override
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        String configResolverClass = servletContext.getInitParameter("oidc.config.resolver");
        OidcClientContext clientContext = (OidcClientContext)servletContext.getAttribute(OidcClientContext.class.getName());
        if (clientContext == null) {
            if (configResolverClass != null) {
                try {
                    OidcClientConfigurationResolver configResolver = (OidcClientConfigurationResolver)servletContext.getClassLoader().loadClass(configResolverClass).newInstance();
                    clientContext = new OidcClientContext(configResolver);
                }
                catch (Exception ex) {
                    clientContext = new OidcClientContext(new OidcClientConfiguration());
                }
            } else {
                InputStream is = this.getConfigInputStream(servletContext);
                OidcClientConfiguration oidcClientConfiguration = is == null ? new OidcClientConfiguration() : OidcClientConfigurationBuilder.build(is);
                clientContext = new OidcClientContext(oidcClientConfiguration);
            }
        }
        servletContext.setAttribute(Oidc.OIDC_CLIENT_CONTEXT_KEY, clientContext);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
    }

    private InputStream getConfigInputStream(ServletContext servletContext) {
        InputStream is = this.getJsonFromServletContext(servletContext);
        if (is == null) {
            String path = servletContext.getInitParameter("oidc.config.file");
            if (path == null) {
                is = servletContext.getResourceAsStream("/WEB-INF/oidc.json");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    throw ElytronMessages.log.oidcConfigFileNotFound(e);
                }
            }
        }
        return is;
    }

    private InputStream getJsonFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.wildfly.security.http.oidc.json.config");
        if (json == null) {
            return null;
        }
        return new ByteArrayInputStream(json.getBytes());
    }
}

