/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.DefaultRouteTemplateContext;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteTemplateDefinition;

public final class TemplatedRouteBuilder {
    private final CamelContext camelContext;
    private final String routeTemplateId;
    private final RouteTemplateContext routeTemplateContext;
    private String routeId;
    private String prefixId;
    private Consumer<RouteTemplateDefinition> handler;
    private Consumer<RouteTemplateContext> configurer;

    private TemplatedRouteBuilder(CamelContext camelContext, String routeTemplateId) {
        this.camelContext = camelContext;
        this.routeTemplateId = routeTemplateId;
        this.routeTemplateContext = new DefaultRouteTemplateContext(camelContext);
    }

    public static TemplatedRouteBuilder builder(CamelContext camelContext, String routeTemplateId) {
        return new TemplatedRouteBuilder(camelContext, routeTemplateId);
    }

    public TemplatedRouteBuilder routeId(String routeId) {
        this.routeId = routeId;
        return this;
    }

    public TemplatedRouteBuilder prefixId(String prefixId) {
        this.prefixId = prefixId;
        return this;
    }

    public TemplatedRouteBuilder parameter(String name, Object value) {
        this.routeTemplateContext.setParameter(name, value);
        return this;
    }

    public TemplatedRouteBuilder parameters(Map<String, Object> parameters) {
        parameters.forEach(this.routeTemplateContext::setParameter);
        return this;
    }

    public TemplatedRouteBuilder bean(String id, Object bean) {
        this.routeTemplateContext.bind(id, bean);
        return this;
    }

    public TemplatedRouteBuilder bean(String id, Class<?> type, Object bean) {
        this.routeTemplateContext.bind(id, type, bean);
        return this;
    }

    public TemplatedRouteBuilder bean(String id, Class<?> type, Supplier<Object> bean) {
        this.routeTemplateContext.bind(id, type, bean);
        return this;
    }

    public TemplatedRouteBuilder handler(Consumer<RouteTemplateDefinition> handler) {
        this.handler = handler;
        return this;
    }

    public TemplatedRouteBuilder configure(Consumer<RouteTemplateContext> configurer) {
        this.configurer = configurer;
        return this;
    }

    public String add() {
        try {
            if (this.handler != null) {
                RouteTemplateDefinition def = ((ModelCamelContext)this.camelContext).getRouteTemplateDefinition(this.routeTemplateId);
                if (def == null) {
                    throw new IllegalArgumentException("Cannot find RouteTemplate with id " + this.routeTemplateId);
                }
                this.handler.accept(def);
            }
            if (this.configurer != null) {
                this.routeTemplateContext.setConfigurer(this.configurer);
            }
            return this.camelContext.addRouteFromTemplate(this.routeId, this.routeTemplateId, this.prefixId, this.routeTemplateContext);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException(e);
        }
    }
}

