/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.camel.support.jsse.CipherSuitesParameters;
import org.apache.camel.support.jsse.FilterParameters;
import org.apache.camel.support.jsse.JsseParameters;
import org.apache.camel.support.jsse.SecureSocketProtocolsParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSSLContextParameters
extends JsseParameters {
    protected static final List<String> DEFAULT_CIPHER_SUITES_FILTER_INCLUDE = List.of(".*");
    protected static final List<String> DEFAULT_CIPHER_SUITES_FILTER_EXCLUDE = List.of(".*_NULL_.*", ".*_anon_.*", ".*_EXPORT_.*", ".*_DES_.*", ".*MD5", ".*RC4.*");
    protected static final List<String> DEFAULT_SECURE_SOCKET_PROTOCOLS_FILTER_INCLUDE = List.of(".*");
    protected static final List<String> DEFAULT_SECURE_SOCKET_PROTOCOLS_FILTER_EXCLUDE = List.of("SSL.*");
    private static final Logger LOG = LoggerFactory.getLogger(BaseSSLContextParameters.class);
    private static final String LS = System.lineSeparator();
    private static final String SSL_ENGINE_CIPHER_SUITE_LOG_MSG = BaseSSLContextParameters.createCipherSuiteLogMessage("SSLEngine");
    private static final String SSL_SOCKET_CIPHER_SUITE_LOG_MSG = BaseSSLContextParameters.createCipherSuiteLogMessage("SSLSocket");
    private static final String SSL_SERVER_SOCKET_CIPHER_SUITE_LOG_MSG = BaseSSLContextParameters.createCipherSuiteLogMessage("SSLServerSocket");
    private static final String SSL_ENGINE_PROTOCOL_LOG_MSG = BaseSSLContextParameters.createProtocolLogMessage("SSLEngine");
    private static final String SSL_SOCKET_PROTOCOL_LOG_MSG = BaseSSLContextParameters.createProtocolLogMessage("SSLSocket");
    private static final String SSL_SERVER_SOCKET_PROTOCOL_LOG_MSG = BaseSSLContextParameters.createProtocolLogMessage("SSLServerSocket");
    private CipherSuitesParameters cipherSuites;
    private FilterParameters cipherSuitesFilter;
    private SecureSocketProtocolsParameters secureSocketProtocols;
    private FilterParameters secureSocketProtocolsFilter;
    private String sessionTimeout;

    protected List<SNIServerName> getSNIHostNames() {
        return Collections.emptyList();
    }

    public CipherSuitesParameters getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(CipherSuitesParameters cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public FilterParameters getCipherSuitesFilter() {
        return this.cipherSuitesFilter;
    }

    public void setCipherSuitesFilter(FilterParameters cipherSuitesFilter) {
        this.cipherSuitesFilter = cipherSuitesFilter;
    }

    public SecureSocketProtocolsParameters getSecureSocketProtocols() {
        return this.secureSocketProtocols;
    }

    public void setSecureSocketProtocols(SecureSocketProtocolsParameters secureSocketProtocols) {
        this.secureSocketProtocols = secureSocketProtocols;
    }

    public FilterParameters getSecureSocketProtocolsFilter() {
        return this.secureSocketProtocolsFilter;
    }

    public void setSecureSocketProtocolsFilter(FilterParameters secureSocketProtocolsFilter) {
        this.secureSocketProtocolsFilter = secureSocketProtocolsFilter;
    }

    public String getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(String sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    protected boolean getAllowPassthrough() {
        return false;
    }

    protected void configureSSLContext(SSLContext context) throws GeneralSecurityException {
        LOG.trace("Configuring client and server side SSLContext parameters on SSLContext [{}]...", (Object)context);
        if (this.getSessionTimeout() != null) {
            LOG.debug("Configuring client and server side SSLContext session timeout on SSLContext [{}] to [{}]", (Object)context, (Object)this.getSessionTimeout());
            this.configureSessionContext(context.getClientSessionContext(), this.getSessionTimeout());
            this.configureSessionContext(context.getServerSessionContext(), this.getSessionTimeout());
        }
        LOG.trace("Configured client and server side SSLContext parameters on SSLContext [{}].", (Object)context);
    }

    protected FilterParameters getDefaultCipherSuitesFilter() {
        FilterParameters filter = new FilterParameters();
        filter.getInclude().addAll(DEFAULT_CIPHER_SUITES_FILTER_INCLUDE);
        filter.getExclude().addAll(DEFAULT_CIPHER_SUITES_FILTER_EXCLUDE);
        return filter;
    }

    protected FilterParameters getDefaultSecureSocketProcotolFilter() {
        FilterParameters filter = new FilterParameters();
        filter.getInclude().addAll(DEFAULT_SECURE_SOCKET_PROTOCOLS_FILTER_INCLUDE);
        filter.getExclude().addAll(DEFAULT_SECURE_SOCKET_PROTOCOLS_FILTER_EXCLUDE);
        return filter;
    }

    protected List<Configurer<SSLEngine>> getSSLEngineConfigurers(SSLContext context) {
        final List<String> enabledCipherSuites = this.getCipherSuites() == null ? null : this.parsePropertyValues(this.getCipherSuites().getCipherSuite());
        final FilterParameters.Patterns defaultEnabledCipherSuitePatterns = this.getDefaultCipherSuitesFilter().getPatterns();
        final FilterParameters.Patterns enabledCipherSuitePatterns = this.getCipherSuitesFilter() != null ? this.getCipherSuitesFilter().getPatterns() : null;
        final List<String> enabledSecureSocketProtocols = this.getSecureSocketProtocols() == null ? null : this.parsePropertyValues(this.getSecureSocketProtocols().getSecureSocketProtocol());
        final FilterParameters.Patterns defaultEnabledSecureSocketProtocolsPatterns = this.getDefaultSecureSocketProcotolFilter().getPatterns();
        final FilterParameters.Patterns enabledSecureSocketProtocolsPatterns = this.getSecureSocketProtocolsFilter() != null ? this.getSecureSocketProtocolsFilter().getPatterns() : null;
        final boolean allowPassthrough = this.getAllowPassthrough();
        Configurer<SSLEngine> sslEngineConfigurer = new Configurer<SSLEngine>(){

            @Override
            public SSLEngine configure(SSLEngine engine) {
                Collection<String> filteredCipherSuites = BaseSSLContextParameters.this.filter(enabledCipherSuites, Arrays.asList(engine.getSSLParameters().getCipherSuites()), Arrays.asList(engine.getEnabledCipherSuites()), enabledCipherSuitePatterns, defaultEnabledCipherSuitePatterns, !allowPassthrough);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SSL_ENGINE_CIPHER_SUITE_LOG_MSG, engine, enabledCipherSuites, enabledCipherSuitePatterns, engine.getSSLParameters().getCipherSuites(), engine.getEnabledCipherSuites(), defaultEnabledCipherSuitePatterns, filteredCipherSuites);
                }
                engine.setEnabledCipherSuites(filteredCipherSuites.toArray(new String[0]));
                Collection<String> filteredSecureSocketProtocols = BaseSSLContextParameters.this.filter(enabledSecureSocketProtocols, Arrays.asList(engine.getSSLParameters().getProtocols()), Arrays.asList(engine.getEnabledProtocols()), enabledSecureSocketProtocolsPatterns, defaultEnabledSecureSocketProtocolsPatterns, !allowPassthrough);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SSL_ENGINE_PROTOCOL_LOG_MSG, engine, enabledSecureSocketProtocols, enabledSecureSocketProtocolsPatterns, engine.getSSLParameters().getProtocols(), engine.getEnabledProtocols(), defaultEnabledSecureSocketProtocolsPatterns, filteredSecureSocketProtocols);
                }
                engine.setEnabledProtocols(filteredSecureSocketProtocols.toArray(new String[0]));
                return engine;
            }
        };
        LinkedList<Configurer<SSLEngine>> sslEngineConfigurers = new LinkedList<Configurer<SSLEngine>>();
        sslEngineConfigurers.add(sslEngineConfigurer);
        return sslEngineConfigurers;
    }

    protected List<Configurer<SSLSocketFactory>> getSSLSocketFactoryConfigurers(SSLContext context) {
        final List<Configurer<SSLSocket>> sslSocketConfigurers = this.getSSLSocketFactorySSLSocketConfigurers(context);
        Configurer<SSLSocketFactory> sslSocketFactoryConfigurer = new Configurer<SSLSocketFactory>(){

            @Override
            public SSLSocketFactory configure(SSLSocketFactory factory) {
                return new SSLSocketFactoryDecorator(factory, sslSocketConfigurers);
            }
        };
        LinkedList<Configurer<SSLSocketFactory>> sslSocketFactoryConfigurers = new LinkedList<Configurer<SSLSocketFactory>>();
        sslSocketFactoryConfigurers.add(sslSocketFactoryConfigurer);
        return sslSocketFactoryConfigurers;
    }

    protected List<Configurer<SSLServerSocketFactory>> getSSLServerSocketFactoryConfigurers(SSLContext context) {
        final List<Configurer<SSLServerSocket>> sslServerSocketConfigurers = this.getSSLServerSocketFactorySSLServerSocketConfigurers(context);
        Configurer<SSLServerSocketFactory> sslServerSocketFactoryConfigurer = new Configurer<SSLServerSocketFactory>(){

            @Override
            public SSLServerSocketFactory configure(SSLServerSocketFactory factory) {
                return new SSLServerSocketFactoryDecorator(factory, sslServerSocketConfigurers);
            }
        };
        LinkedList<Configurer<SSLServerSocketFactory>> sslServerSocketFactoryConfigurers = new LinkedList<Configurer<SSLServerSocketFactory>>();
        sslServerSocketFactoryConfigurers.add(sslServerSocketFactoryConfigurer);
        return sslServerSocketFactoryConfigurers;
    }

    protected List<Configurer<SSLSocket>> getSSLSocketFactorySSLSocketConfigurers(SSLContext context) {
        final List<String> enabledCipherSuites = this.getCipherSuites() == null ? null : this.parsePropertyValues(this.getCipherSuites().getCipherSuite());
        final FilterParameters.Patterns defaultEnabledCipherSuitePatterns = this.getDefaultCipherSuitesFilter().getPatterns();
        final FilterParameters.Patterns enabledCipherSuitePatterns = this.getCipherSuitesFilter() != null ? this.getCipherSuitesFilter().getPatterns() : null;
        final List<String> enabledSecureSocketProtocols = this.getSecureSocketProtocols() == null ? null : this.parsePropertyValues(this.getSecureSocketProtocols().getSecureSocketProtocol());
        final FilterParameters.Patterns defaultEnabledSecureSocketProtocolsPatterns = this.getDefaultSecureSocketProcotolFilter().getPatterns();
        final FilterParameters.Patterns enabledSecureSocketProtocolsPatterns = this.getSecureSocketProtocolsFilter() != null ? this.getSecureSocketProtocolsFilter().getPatterns() : null;
        final boolean allowPassthrough = this.getAllowPassthrough();
        Configurer<SSLSocket> sslSocketConfigurer = new Configurer<SSLSocket>(){

            @Override
            public SSLSocket configure(SSLSocket socket) {
                if (!BaseSSLContextParameters.this.getSNIHostNames().isEmpty()) {
                    SSLParameters sslParameters = socket.getSSLParameters();
                    sslParameters.setServerNames(BaseSSLContextParameters.this.getSNIHostNames());
                    socket.setSSLParameters(sslParameters);
                }
                Collection<String> filteredCipherSuites = BaseSSLContextParameters.this.filter(enabledCipherSuites, Arrays.asList(socket.getSSLParameters().getCipherSuites()), Arrays.asList(socket.getEnabledCipherSuites()), enabledCipherSuitePatterns, defaultEnabledCipherSuitePatterns, !allowPassthrough);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SSL_SOCKET_CIPHER_SUITE_LOG_MSG, socket, enabledCipherSuites, enabledCipherSuitePatterns, socket.getSSLParameters().getCipherSuites(), socket.getEnabledCipherSuites(), defaultEnabledCipherSuitePatterns, filteredCipherSuites);
                }
                socket.setEnabledCipherSuites(filteredCipherSuites.toArray(new String[0]));
                Collection<String> filteredSecureSocketProtocols = BaseSSLContextParameters.this.filter(enabledSecureSocketProtocols, Arrays.asList(socket.getSSLParameters().getProtocols()), Arrays.asList(socket.getEnabledProtocols()), enabledSecureSocketProtocolsPatterns, defaultEnabledSecureSocketProtocolsPatterns, !allowPassthrough);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SSL_SOCKET_PROTOCOL_LOG_MSG, socket, enabledSecureSocketProtocols, enabledSecureSocketProtocolsPatterns, socket.getSSLParameters().getProtocols(), socket.getEnabledProtocols(), defaultEnabledSecureSocketProtocolsPatterns, filteredSecureSocketProtocols);
                }
                socket.setEnabledProtocols(filteredSecureSocketProtocols.toArray(new String[0]));
                return socket;
            }
        };
        LinkedList<Configurer<SSLSocket>> sslSocketConfigurers = new LinkedList<Configurer<SSLSocket>>();
        sslSocketConfigurers.add(sslSocketConfigurer);
        return sslSocketConfigurers;
    }

    protected List<Configurer<SSLServerSocket>> getSSLServerSocketFactorySSLServerSocketConfigurers(SSLContext context) {
        final List<String> enabledCipherSuites = this.getCipherSuites() == null ? null : this.parsePropertyValues(this.getCipherSuites().getCipherSuite());
        final FilterParameters.Patterns defaultEnabledCipherSuitePatterns = this.getDefaultCipherSuitesFilter().getPatterns();
        final FilterParameters.Patterns enabledCipherSuitePatterns = this.getCipherSuitesFilter() != null ? this.getCipherSuitesFilter().getPatterns() : null;
        final List<String> enabledSecureSocketProtocols = this.getSecureSocketProtocols() == null ? null : this.parsePropertyValues(this.getSecureSocketProtocols().getSecureSocketProtocol());
        final FilterParameters.Patterns defaultEnabledSecureSocketProtocolsPatterns = this.getDefaultSecureSocketProcotolFilter().getPatterns();
        final FilterParameters.Patterns enabledSecureSocketProtocolsPatterns = this.getSecureSocketProtocolsFilter() != null ? this.getSecureSocketProtocolsFilter().getPatterns() : null;
        final boolean allowPassthrough = this.getAllowPassthrough();
        Configurer<SSLServerSocket> sslServerSocketConfigurer = new Configurer<SSLServerSocket>(){

            @Override
            public SSLServerSocket configure(SSLServerSocket socket) {
                Collection<String> filteredCipherSuites = BaseSSLContextParameters.this.filter(enabledCipherSuites, Arrays.asList(socket.getSupportedCipherSuites()), Arrays.asList(socket.getEnabledCipherSuites()), enabledCipherSuitePatterns, defaultEnabledCipherSuitePatterns, !allowPassthrough);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SSL_SERVER_SOCKET_CIPHER_SUITE_LOG_MSG, socket, enabledCipherSuites, enabledCipherSuitePatterns, socket.getSupportedCipherSuites(), socket.getEnabledCipherSuites(), defaultEnabledCipherSuitePatterns, filteredCipherSuites);
                }
                socket.setEnabledCipherSuites(filteredCipherSuites.toArray(new String[0]));
                Collection<String> filteredSecureSocketProtocols = BaseSSLContextParameters.this.filter(enabledSecureSocketProtocols, Arrays.asList(socket.getSupportedProtocols()), Arrays.asList(socket.getEnabledProtocols()), enabledSecureSocketProtocolsPatterns, defaultEnabledSecureSocketProtocolsPatterns, !allowPassthrough);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SSL_SERVER_SOCKET_PROTOCOL_LOG_MSG, socket, enabledSecureSocketProtocols, enabledSecureSocketProtocolsPatterns, socket.getSupportedProtocols(), socket.getEnabledProtocols(), defaultEnabledSecureSocketProtocolsPatterns, filteredSecureSocketProtocols);
                }
                socket.setEnabledProtocols(filteredSecureSocketProtocols.toArray(new String[0]));
                return socket;
            }
        };
        LinkedList<Configurer<SSLServerSocket>> sslServerSocketConfigurers = new LinkedList<Configurer<SSLServerSocket>>();
        sslServerSocketConfigurers.add(sslServerSocketConfigurer);
        return sslServerSocketConfigurers;
    }

    protected void configureSessionContext(SSLSessionContext sessionContext, String sessionTimeout) throws GeneralSecurityException {
        int sessionTimeoutInt = Integer.parseInt(this.parsePropertyValue(sessionTimeout));
        if (sessionContext == null) {
            throw new GeneralSecurityException("The SSLContext does not support SSLSessionContext, but a session timeout is configured. Set sessionTimeout to null to avoid this error.");
        }
        sessionContext.setSessionTimeout(sessionTimeoutInt);
    }

    protected Collection<String> filter(Collection<String> explicitValues, Collection<String> availableValues, Collection<String> currentValues, FilterParameters.Patterns patterns, FilterParameters.Patterns defaultPatterns, boolean applyDefaults) {
        List<Pattern> enabledExcludePatterns;
        List<Pattern> enabledIncludePatterns;
        if (explicitValues == null && patterns == null && !applyDefaults) {
            return currentValues;
        }
        if (patterns != null) {
            enabledIncludePatterns = patterns.getIncludes();
            enabledExcludePatterns = patterns.getExcludes();
        } else {
            enabledIncludePatterns = defaultPatterns.getIncludes();
            enabledExcludePatterns = defaultPatterns.getExcludes();
        }
        return this.filter(explicitValues, availableValues, enabledIncludePatterns, enabledExcludePatterns);
    }

    protected Collection<String> filter(Collection<String> explicitValues, Collection<String> availableValues, List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        LinkedList<String> returnValues;
        if (explicitValues != null) {
            returnValues = new ArrayList<String>(explicitValues);
        } else {
            returnValues = new LinkedList();
            for (String value : availableValues) {
                if (!this.matchesOneOf(value, includePatterns) || this.matchesOneOf(value, excludePatterns)) continue;
                returnValues.add(value);
            }
        }
        return returnValues;
    }

    protected boolean matchesOneOf(String value, List<Pattern> patterns) {
        boolean matches = false;
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(value);
            if (!matcher.matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }

    private static String collectionAsCommaDelimitedString(String[] col) {
        return col == null || col.length == 0 ? "" : String.join((CharSequence)",", col);
    }

    private static String createCipherSuiteLogMessage(String entityName) {
        return "Configuring " + entityName + " [{}] with " + LS + "\t explicitly set cipher suites [{}]," + LS + "\t cipher suite patterns [{}]," + LS + "\t available cipher suites [{}]," + LS + "\t currently enabled cipher suites [{}]," + LS + "\t and default cipher suite patterns [{}]." + LS + "\t Resulting enabled cipher suites are [{}].";
    }

    private static String createProtocolLogMessage(String entityName) {
        return "Configuring " + entityName + " [{}] with " + LS + "\t explicitly set protocols [{}]," + LS + "\t protocol patterns [{}]," + LS + "\t available protocols [{}]," + LS + "\t currently enabled protocols [{}]," + LS + "\t and default protocol patterns [{}]." + LS + "\t Resulting enabled protocols are [{}].";
    }

    protected static final class SSLSocketFactoryDecorator
    extends SSLSocketFactory {
        private final SSLSocketFactory sslSocketFactory;
        private final List<Configurer<SSLSocket>> sslSocketConfigurers;

        public SSLSocketFactoryDecorator(SSLSocketFactory sslSocketFactory, List<Configurer<SSLSocket>> sslSocketConfigurers) {
            this.sslSocketFactory = sslSocketFactory;
            this.sslSocketConfigurers = sslSocketConfigurers;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.sslSocketFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.sslSocketFactory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.configureSocket(this.sslSocketFactory.createSocket());
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.configureSocket(this.sslSocketFactory.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.configureSocket(this.sslSocketFactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.configureSocket(this.sslSocketFactory.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.configureSocket(this.sslSocketFactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.configureSocket(this.sslSocketFactory.createSocket(address, port, localAddress, localPort));
        }

        public SSLSocketFactory getDelegate() {
            return this.sslSocketFactory;
        }

        private Socket configureSocket(Socket s) {
            SSLSocket workingSocket = (SSLSocket)s;
            LOG.debug("Created Socket [{}] from SocketFactory [{}].", (Object)s, (Object)this.sslSocketFactory);
            for (Configurer<SSLSocket> configurer : this.sslSocketConfigurers) {
                workingSocket = configurer.configure(workingSocket);
            }
            return workingSocket;
        }
    }

    protected static final class SSLServerSocketFactoryDecorator
    extends SSLServerSocketFactory {
        private final SSLServerSocketFactory sslServerSocketFactory;
        private final List<Configurer<SSLServerSocket>> sslServerSocketConfigurers;

        public SSLServerSocketFactoryDecorator(SSLServerSocketFactory sslServerSocketFactory, List<Configurer<SSLServerSocket>> sslServerSocketConfigurers) {
            this.sslServerSocketFactory = sslServerSocketFactory;
            this.sslServerSocketConfigurers = sslServerSocketConfigurers;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.sslServerSocketFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.sslServerSocketFactory.getSupportedCipherSuites();
        }

        @Override
        public ServerSocket createServerSocket() throws IOException {
            return this.configureSocket(this.sslServerSocketFactory.createServerSocket());
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
            return this.configureSocket(this.sslServerSocketFactory.createServerSocket(port, backlog, ifAddress));
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return this.configureSocket(this.sslServerSocketFactory.createServerSocket(port, backlog));
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return this.configureSocket(this.sslServerSocketFactory.createServerSocket(port));
        }

        public SSLServerSocketFactory getDelegate() {
            return this.sslServerSocketFactory;
        }

        private ServerSocket configureSocket(ServerSocket s) {
            SSLServerSocket workingSocket = (SSLServerSocket)s;
            LOG.debug("Created ServerSocket [{}] from SslServerSocketFactory [{}].", (Object)s, (Object)this.sslServerSocketFactory);
            for (Configurer<SSLServerSocket> configurer : this.sslServerSocketConfigurers) {
                workingSocket = configurer.configure(workingSocket);
            }
            return workingSocket;
        }
    }

    protected static final class SSLContextSpiDecorator
    extends SSLContextSpi {
        private final SSLContext context;
        private final List<Configurer<SSLEngine>> sslEngineConfigurers;
        private final List<Configurer<SSLSocketFactory>> sslSocketFactoryConfigurers;
        private final List<Configurer<SSLServerSocketFactory>> sslServerSocketFactoryConfigurers;

        public SSLContextSpiDecorator(SSLContext context, List<Configurer<SSLEngine>> sslEngineConfigurers, List<Configurer<SSLSocketFactory>> sslSocketFactoryConfigurers, List<Configurer<SSLServerSocketFactory>> sslServerSocketFactoryConfigurers) {
            this.context = context;
            this.sslEngineConfigurers = sslEngineConfigurers;
            this.sslSocketFactoryConfigurers = sslSocketFactoryConfigurers;
            this.sslServerSocketFactoryConfigurers = sslServerSocketFactoryConfigurers;
        }

        @Override
        protected SSLEngine engineCreateSSLEngine() {
            SSLEngine engine = this.context.createSSLEngine();
            LOG.debug("SSLEngine [{}] created from SSLContext [{}].", (Object)engine, (Object)this.context);
            this.configureSSLEngine(engine);
            return engine;
        }

        @Override
        protected SSLEngine engineCreateSSLEngine(String peerHost, int peerPort) {
            SSLEngine engine = this.context.createSSLEngine(peerHost, peerPort);
            LOG.debug("SSLEngine [{}] created from SSLContext [{}].", (Object)engine, (Object)this.context);
            return this.configureSSLEngine(engine);
        }

        @Override
        protected SSLSessionContext engineGetClientSessionContext() {
            return this.context.getClientSessionContext();
        }

        @Override
        protected SSLSessionContext engineGetServerSessionContext() {
            return this.context.getServerSessionContext();
        }

        @Override
        protected SSLServerSocketFactory engineGetServerSocketFactory() {
            SSLServerSocketFactory factory = this.context.getServerSocketFactory();
            LOG.debug("SSLServerSocketFactoryEngine [{}] created from SSLContext [{}].", (Object)factory, (Object)this.context);
            return this.configureSSLServerSocketFactory(factory);
        }

        @Override
        protected SSLSocketFactory engineGetSocketFactory() {
            SSLSocketFactory factory = this.context.getSocketFactory();
            LOG.debug("SSLSocketFactory [{}] created from SSLContext [{}].", (Object)factory, (Object)this.context);
            return this.configureSSLSocketFactory(factory);
        }

        @Override
        protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws KeyManagementException {
            this.context.init(km, tm, random);
        }

        private SSLContext getDelegate() {
            return this.context;
        }

        private SSLEngine configureSSLEngine(SSLEngine engine) {
            SSLEngine workingEngine = engine;
            for (Configurer<SSLEngine> configurer : this.sslEngineConfigurers) {
                workingEngine = configurer.configure(workingEngine);
            }
            return workingEngine;
        }

        private SSLSocketFactory configureSSLSocketFactory(SSLSocketFactory factory) {
            SSLSocketFactory workingFactory = factory;
            for (Configurer<SSLSocketFactory> configurer : this.sslSocketFactoryConfigurers) {
                workingFactory = configurer.configure(workingFactory);
            }
            return workingFactory;
        }

        private SSLServerSocketFactory configureSSLServerSocketFactory(SSLServerSocketFactory factory) {
            SSLServerSocketFactory workingFactory = factory;
            for (Configurer<SSLServerSocketFactory> configurer : this.sslServerSocketFactoryConfigurers) {
                workingFactory = configurer.configure(workingFactory);
            }
            return workingFactory;
        }
    }

    protected static final class SSLContextDecorator
    extends SSLContext {
        public SSLContextDecorator(SSLContextSpiDecorator decorator) {
            super(decorator, decorator.getDelegate().getProvider(), decorator.getDelegate().getProtocol());
            LOG.debug("SSLContextDecorator [{}] decorating SSLContext [{}].", (Object)this, (Object)decorator.getDelegate());
        }

        public String toString() {
            return String.format("SSLContext[hash=%h, provider=%s, protocol=%s, needClientAuth=%s, wantClientAuth=%s%n\tdefaultProtocols=%s%n\tdefaultCipherSuites=%s%n\tsupportedProtocols=%s%n\tsupportedCipherSuites=%s%n]", this.hashCode(), this.getProvider(), this.getProtocol(), this.getDefaultSSLParameters().getNeedClientAuth(), this.getDefaultSSLParameters().getWantClientAuth(), BaseSSLContextParameters.collectionAsCommaDelimitedString(this.getDefaultSSLParameters().getProtocols()), BaseSSLContextParameters.collectionAsCommaDelimitedString(this.getDefaultSSLParameters().getCipherSuites()), BaseSSLContextParameters.collectionAsCommaDelimitedString(this.getSupportedSSLParameters().getProtocols()), BaseSSLContextParameters.collectionAsCommaDelimitedString(this.getSupportedSSLParameters().getCipherSuites()));
        }
    }

    protected static interface Configurer<T> {
        public T configure(T var1);
    }
}

