/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.PredicateExceptionFactory;
import org.apache.camel.support.processor.PredicateValidationException;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateValidatingProcessor
extends ServiceSupport
implements Processor,
Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(PredicateValidatingProcessor.class);
    private final Predicate predicate;
    private PredicateExceptionFactory predicateExceptionFactory;
    private String id;

    public PredicateValidatingProcessor(Predicate predicate) {
        ObjectHelper.notNull(predicate, "predicate", this);
        this.predicate = predicate;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        boolean matches = this.predicate.matches(exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validation {} for {} with Predicate[{}]", matches ? "succeed" : "failed", exchange, this.predicate);
        }
        if (!matches) {
            Exception cause = null;
            if (this.predicateExceptionFactory != null) {
                cause = this.predicateExceptionFactory.newPredicateException(exchange, this.predicate, this.getId());
            }
            if (cause == null) {
                cause = new PredicateValidationException(exchange, this.predicate);
            }
            throw cause;
        }
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public PredicateExceptionFactory getPredicateExceptionFactory() {
        return this.predicateExceptionFactory;
    }

    public void setPredicateExceptionFactory(PredicateExceptionFactory predicateExceptionFactory) {
        this.predicateExceptionFactory = predicateExceptionFactory;
    }

    public String toString() {
        return "validate(" + this.predicate + ")";
    }

    @Override
    public String getTraceLabel() {
        return "validate[" + this.predicate + "]";
    }
}

