/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.common;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.wildfly.elytron.web.undertow.common.AbstractHttpServerMechanismTest;
import org.wildfly.elytron.web.undertow.common.UndertowServer;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.permission.PermissionVerifier;

public abstract class FormAuthenticationBase
extends AbstractHttpServerMechanismTest {
    @Rule
    public UndertowServer server = this.createUndertowServer();
    private AtomicInteger realmIdentityInvocationCount = new AtomicInteger(0);

    protected FormAuthenticationBase() throws Exception {
    }

    @Test
    public void testRedirectLoginPage() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        FormAuthenticationBase.assertLoginPage(httpClient.execute(new HttpGet(this.server.createUri())));
    }

    @Test
    public void testFormSuccessfulAuthentication() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy(new LaxRedirectStrategy()).build();
        HttpPost httpAuthenticate = new HttpPost(this.server.createUri("/j_security_check"));
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(2);
        parameters.add(new BasicNameValuePair("j_username", "ladybird"));
        parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
        httpAuthenticate.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
        this.assertSuccessfulResponse(httpClient.execute(httpAuthenticate), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(httpAuthenticate), "ladybird");
    }

    @Test
    public void testSessionIdentityCache() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy(new LaxRedirectStrategy()).build();
        HttpPost httpAuthenticate = new HttpPost(this.server.createUri("/j_security_check"));
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(2);
        parameters.add(new BasicNameValuePair("j_username", "ladybird"));
        parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
        httpAuthenticate.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
        this.assertSuccessfulResponse(httpClient.execute(httpAuthenticate), "ladybird");
        for (int i = 0; i < 10; ++i) {
            this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.server.createUri())), "ladybird");
        }
        Assert.assertEquals((long)1L, (long)this.realmIdentityInvocationCount.get());
    }

    @Test
    public void testLogout() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy(new LaxRedirectStrategy()).build();
        HttpPost httpAuthenticate = new HttpPost(this.server.createUri("/j_security_check"));
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(2);
        parameters.add(new BasicNameValuePair("j_username", "ladybird"));
        parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
        httpAuthenticate.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
        this.assertSuccessfulResponse(httpClient.execute(httpAuthenticate), "ladybird");
        this.assertSuccessfulResponse(httpClient.execute(new HttpGet(this.server.createUri())), "ladybird");
        httpClient.execute(new HttpGet(this.server.createUri("/logout")));
        FormAuthenticationBase.assertLoginPage(httpClient.execute(new HttpGet(this.server.createUri())));
    }

    @Override
    protected String getMechanismName() {
        return "FORM";
    }

    @Override
    protected SecurityDomain doCreateSecurityDomain() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance("clear");
        HashMap<String, SimpleRealmEntry> passwordMap = new HashMap<String, SimpleRealmEntry>();
        passwordMap.put("ladybird", new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(passwordFactory.generatePassword(new ClearPasswordSpec("Coleoptera".toCharArray()))))));
        final SimpleMapBackedSecurityRealm delegate = new SimpleMapBackedSecurityRealm();
        delegate.setPasswordMap(passwordMap);
        SecurityRealm securityRealm = new SecurityRealm(){

            @Override
            public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
                FormAuthenticationBase.this.realmIdentityInvocationCount.incrementAndGet();
                return delegate.getRealmIdentity(principal);
            }

            @Override
            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec algorithmParameterSpec) throws RealmUnavailableException {
                return delegate.getCredentialAcquireSupport(credentialType, algorithmName, algorithmParameterSpec);
            }

            @Override
            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return delegate.getEvidenceVerifySupport(evidenceType, algorithmName);
            }
        };
        SecurityDomain.Builder builder = SecurityDomain.builder().setDefaultRealmName("TestRealm");
        builder.addRealm("TestRealm", securityRealm).build();
        builder.setPermissionMapper((principal, roles) -> PermissionVerifier.from(new LoginPermission()));
        return builder.build();
    }

    protected abstract UndertowServer createUndertowServer() throws Exception;
}

