/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.bearer;

import java.security.Provider;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.bearer.BearerTokenAuthenticationMechanism;

public class BearerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    public BearerMechanismFactory() {
    }

    public BearerMechanismFactory(Provider provider) {
    }

    public BearerMechanismFactory(Provider ... providers) {
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        return new String[]{"BEARER_TOKEN"};
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        Assert.checkNotNullParam("mechanismName", mechanismName);
        Assert.checkNotNullParam("properties", properties);
        Assert.checkNotNullParam("callbackHandler", callbackHandler);
        if ("BEARER_TOKEN".equals(mechanismName)) {
            return new BearerTokenAuthenticationMechanism(callbackHandler);
        }
        return null;
    }
}

