/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.predicate.Predicate;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RequestStatistics;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.FastConcurrentDirectDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ActiveRequestTrackerHandler
implements HttpHandler {
    private final FastConcurrentDirectDeque<RequestStatistics> trackedRequests = new FastConcurrentDirectDeque();
    private final HttpHandler next;
    private final Predicate predicate;

    public ActiveRequestTrackerHandler(HttpHandler next, Predicate predicate) {
        if (next == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("next");
        }
        this.predicate = predicate;
        this.next = next;
    }

    public List<RequestStatistics> getTrackedRequests() {
        return new ArrayList<RequestStatistics>(this.trackedRequests);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.predicate == null || this.predicate.resolve(exchange)) {
            RequestStatistics stats = new RequestStatistics(exchange);
            this.trackedRequests.add(stats);
            exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                this.trackedRequests.remove(stats);
                nextListener.proceed();
            });
        }
        this.next.handleRequest(exchange);
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new ActiveRequestTrackerHandler(handler, null);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "track-request";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }
}

