/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.PluginHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiMethodPropertiesHelper<C> {
    protected static final Logger LOG = LoggerFactory.getLogger(ApiMethodPropertiesHelper.class);
    protected final Set<String> componentConfigFields = new HashSet<String>();
    protected final Class<?> componentConfigClass;
    protected final String propertyPrefix;
    private final int prefixLength;
    private final String camelCasePrefix;

    protected ApiMethodPropertiesHelper(CamelContext context, Class<C> componentConfiguration, String propertyPrefix) {
        this.componentConfigClass = componentConfiguration;
        this.propertyPrefix = propertyPrefix;
        this.prefixLength = propertyPrefix.length();
        this.camelCasePrefix = !Character.isLetterOrDigit(propertyPrefix.charAt(this.prefixLength - 1)) ? propertyPrefix.substring(0, this.prefixLength - 1) : null;
        PropertyConfigurer configurer = PluginHelper.getConfigurerResolver(context).resolvePropertyConfigurer(componentConfiguration.getName(), context);
        if (configurer instanceof ExtendedPropertyConfigurerGetter) {
            ExtendedPropertyConfigurerGetter getter = (ExtendedPropertyConfigurerGetter)((Object)configurer);
            Set<String> names = getter.getAllOptions(null).keySet();
            for (String name : names) {
                String key = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                this.componentConfigFields.add(key);
            }
        } else {
            for (Field field : componentConfiguration.getDeclaredFields()) {
                this.componentConfigFields.add(field.getName());
            }
        }
    }

    public Map<String, Object> getExchangeProperties(Exchange exchange, Map<String, Object> properties) {
        int nProperties = 0;
        for (Map.Entry<String, Object> entry : exchange.getIn().getHeaders().entrySet()) {
            String key = entry.getKey();
            if (key.startsWith(this.propertyPrefix)) {
                properties.put(key.substring(this.prefixLength), entry.getValue());
                ++nProperties;
                continue;
            }
            if (this.camelCasePrefix == null || !key.startsWith(this.camelCasePrefix)) continue;
            String propertyName = Character.toLowerCase(key.charAt(this.prefixLength - 1)) + key.substring(this.prefixLength);
            properties.put(propertyName, entry.getValue());
            ++nProperties;
        }
        LOG.debug("Found {} properties in exchange", (Object)nProperties);
        return properties;
    }

    public void getEndpointProperties(CamelContext context, Object endpointConfiguration, Map<String, Object> properties) {
        PropertyConfigurer configurer = PluginHelper.getConfigurerResolver(context).resolvePropertyConfigurer(endpointConfiguration.getClass().getName(), context);
        if (configurer instanceof ExtendedPropertyConfigurerGetter) {
            ExtendedPropertyConfigurerGetter getter = (ExtendedPropertyConfigurerGetter)((Object)configurer);
            ApiMethodPropertiesHelper.useGetters(endpointConfiguration, properties, getter);
        } else {
            PluginHelper.getBeanIntrospection(context).getProperties(endpointConfiguration, properties, null, false);
        }
        for (String key : this.componentConfigFields) {
            properties.remove(key);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found endpoint properties {}", (Object)properties.keySet());
        }
    }

    public Set<String> getEndpointPropertyNames(CamelContext context, Object endpointConfiguration) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.getEndpointProperties(context, endpointConfiguration, properties);
        return Collections.unmodifiableSet(properties.keySet());
    }

    public Set<String> getValidEndpointProperties(CamelContext context, Object endpointConfiguration) {
        HashSet<Object> fields = new HashSet<Object>();
        PropertyConfigurer configurer = PluginHelper.getConfigurerResolver(context).resolvePropertyConfigurer(endpointConfiguration.getClass().getName(), context);
        if (configurer instanceof ExtendedPropertyConfigurerGetter) {
            ExtendedPropertyConfigurerGetter getter = (ExtendedPropertyConfigurerGetter)((Object)configurer);
            Set<String> names = getter.getAllOptions(endpointConfiguration).keySet();
            for (String name : names) {
                String key = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                fields.add(key);
            }
        } else {
            for (Field field : endpointConfiguration.getClass().getDeclaredFields()) {
                fields.add(field.getName());
            }
        }
        return Collections.unmodifiableSet(fields);
    }

    public void getConfigurationProperties(CamelContext context, Object endpointConfiguration, Map<String, Object> properties) {
        PropertyConfigurer configurer = PluginHelper.getConfigurerResolver(context).resolvePropertyConfigurer(endpointConfiguration.getClass().getName(), context);
        if (configurer instanceof ExtendedPropertyConfigurerGetter) {
            ExtendedPropertyConfigurerGetter getter = (ExtendedPropertyConfigurerGetter)((Object)configurer);
            ApiMethodPropertiesHelper.useGetters(endpointConfiguration, properties, getter);
        } else {
            PluginHelper.getBeanIntrospection(context).getProperties(endpointConfiguration, properties, null, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found configuration properties {}", (Object)properties.keySet());
        }
    }

    private static void useGetters(Object endpointConfiguration, Map<String, Object> properties, ExtendedPropertyConfigurerGetter configurer) {
        ExtendedPropertyConfigurerGetter getter = configurer;
        Set<String> all = getter.getAllOptions(endpointConfiguration).keySet();
        for (String name : all) {
            Object value = getter.getOptionValue(endpointConfiguration, name, true);
            if (value == null) continue;
            String key = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            properties.put(key, value);
        }
    }
}

