/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.support.jsse.JsseParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreParameters
extends JsseParameters {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreParameters.class);
    protected String type;
    protected String password;
    protected String provider;
    protected KeyStore keyStore;
    protected String resource;

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String value) {
        this.resource = value;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public KeyStore createKeyStore() throws GeneralSecurityException, IOException {
        if (this.resource != null) {
            this.resource = this.parsePropertyValue(this.resource);
        }
        if (this.keyStore == null && this.resource != null && this.resource.startsWith("ref:")) {
            String ref = this.resource.substring(4);
            this.keyStore = this.getCamelContext().getRegistry().lookupByNameAndType(ref, KeyStore.class);
        }
        if (this.keyStore != null) {
            if (LOG.isDebugEnabled()) {
                List<String> aliases = this.extractAliases(this.keyStore);
                LOG.debug("KeyStore [{}], initialized from [{}], is using provider [{}], has type [{}], and contains aliases {}.", this.keyStore, this, this.keyStore.getProvider(), this.keyStore.getType(), aliases);
            }
            return this.keyStore;
        }
        LOG.trace("Creating KeyStore instance from KeyStoreParameters [{}].", (Object)this);
        String ksType = this.parsePropertyValue(this.type);
        if (ksType == null) {
            ksType = KeyStore.getDefaultType();
        }
        char[] ksPassword = null;
        if (this.password != null) {
            ksPassword = this.parsePropertyValue(this.password).toCharArray();
        }
        KeyStore ks = this.provider == null ? KeyStore.getInstance(ksType) : KeyStore.getInstance(ksType, this.parsePropertyValue(this.provider));
        if (this.resource == null) {
            ks.load(null, ksPassword);
        } else {
            InputStream is = this.resolveResource(this.resource);
            if (is == null) {
                LOG.warn("No keystore could be found at {}.", (Object)this.resource);
            } else {
                try (InputStream inputStream = is;){
                    ks.load(is, ksPassword);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            List<String> aliases = this.extractAliases(ks);
            LOG.debug("KeyStore [{}], initialized from [{}], is using provider [{}], has type [{}], and contains aliases {}.", ks, this, ks.getProvider(), ks.getType(), aliases);
        }
        return ks;
    }

    private List<String> extractAliases(KeyStore ks) {
        LinkedList<String> aliases = new LinkedList<String>();
        Enumeration<String> aliasEnum = null;
        try {
            aliasEnum = ks.aliases();
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (aliasEnum != null) {
            while (aliasEnum.hasMoreElements()) {
                aliases.add(aliasEnum.nextElement());
            }
        }
        return aliases;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("KeyStoreParameters[type=");
        builder.append(this.type);
        builder.append(", password=");
        builder.append("********");
        builder.append(", provider=");
        builder.append(this.provider);
        builder.append(", resource=");
        builder.append(this.resource);
        builder.append("]");
        return builder.toString();
    }
}

