/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.text.NumberFormat;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThroughputLogger
extends AsyncProcessorSupport
implements AsyncProcessor,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(ThroughputLogger.class);
    private String id;
    private String routeId;
    private final AtomicLong receivedCounter = new AtomicLong();
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private long groupReceivedCount;
    private boolean groupActiveOnly;
    private Integer groupSize;
    private long groupDelay = 1000L;
    private Long groupInterval;
    private final StopWatch groupWatch = new StopWatch();
    private final StopWatch testWatch = new StopWatch();
    private String action = "Received";
    private CamelContext camelContext;
    private ScheduledExecutorService logSchedulerService;
    private final CamelLogger logger;
    private String lastLogMessage;
    private double rate;
    private double average;

    public ThroughputLogger(CamelLogger logger2) {
        this.logger = logger2;
    }

    public ThroughputLogger(CamelLogger logger2, Integer groupSize) {
        this(logger2);
        this.setGroupSize(groupSize);
    }

    public ThroughputLogger(CamelLogger logger2, CamelContext camelContext, Long groupInterval, Long groupDelay, Boolean groupActiveOnly) {
        this(logger2);
        this.camelContext = camelContext;
        this.setGroupInterval(groupInterval);
        this.setGroupActiveOnly(groupActiveOnly);
        if (groupDelay != null) {
            this.setGroupDelay(groupDelay);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        long receivedCount = this.receivedCounter.incrementAndGet();
        if (this.groupSize != null && receivedCount % (long)this.groupSize.intValue() == 0L) {
            this.lastLogMessage = this.createLogMessage(exchange, receivedCount);
            this.logger.log(this.lastLogMessage);
        }
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(Integer groupSize) {
        if (groupSize == null || groupSize <= 0) {
            throw new IllegalArgumentException("groupSize must be positive, was: " + groupSize);
        }
        this.groupSize = groupSize;
    }

    public Long getGroupInterval() {
        return this.groupInterval;
    }

    public void setGroupInterval(Long groupInterval) {
        if (groupInterval == null || groupInterval <= 0L) {
            throw new IllegalArgumentException("groupInterval must be positive, was: " + groupInterval);
        }
        this.groupInterval = groupInterval;
    }

    public long getGroupDelay() {
        return this.groupDelay;
    }

    public void setGroupDelay(long groupDelay) {
        this.groupDelay = groupDelay;
    }

    public boolean getGroupActiveOnly() {
        return this.groupActiveOnly;
    }

    private void setGroupActiveOnly(boolean groupActiveOnly) {
        this.groupActiveOnly = groupActiveOnly;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void reset() {
        this.receivedCounter.set(0L);
        this.groupReceivedCount = 0L;
        this.average = 0.0;
        this.rate = 0.0;
        this.lastLogMessage = null;
    }

    public double getRate() {
        return this.rate;
    }

    public double getAverage() {
        return this.average;
    }

    public long getReceivedCounter() {
        return this.receivedCounter.get();
    }

    public String getLastLogMessage() {
        return this.lastLogMessage;
    }

    @Override
    public void doStart() throws Exception {
        if (this.groupInterval != null) {
            ObjectHelper.notNull(this.camelContext, "CamelContext", this);
            this.logSchedulerService = this.camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor(this, "ThroughputLogger");
            ScheduledLogTask scheduledLogTask = new ScheduledLogTask();
            LOG.info("Scheduling throughput logger to run every {} millis.", (Object)this.groupInterval);
            this.logSchedulerService.scheduleAtFixedRate(scheduledLogTask, this.groupDelay, this.groupInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void doStop() throws Exception {
        if (this.logSchedulerService != null) {
            this.camelContext.getExecutorServiceManager().shutdown(this.logSchedulerService);
            this.logSchedulerService = null;
        }
    }

    protected String createLogMessage(Exchange exchange, long receivedCount) {
        long groupDuration = this.groupWatch.takenAndRestart();
        long testDuration = this.testWatch.taken();
        this.rate = this.messagesPerSecond(this.groupSize.intValue(), groupDuration);
        this.average = this.messagesPerSecond(receivedCount, testDuration);
        return this.getAction() + ": " + receivedCount + " messages so far. Last group took: " + groupDuration + " millis which is: " + this.numberFormat.format(this.rate) + " messages per second. average: " + this.numberFormat.format(this.average);
    }

    protected void createGroupIntervalLogMessage() {
        long receivedCount = this.receivedCounter.get();
        if (this.groupActiveOnly && receivedCount == this.groupReceivedCount) {
            return;
        }
        long groupDuration = this.groupWatch.takenAndRestart();
        long testDuration = this.testWatch.taken();
        long currentCount = receivedCount - this.groupReceivedCount;
        this.rate = this.messagesPerSecond(currentCount, groupDuration);
        this.average = this.messagesPerSecond(receivedCount, testDuration);
        this.groupReceivedCount = receivedCount;
        this.lastLogMessage = this.getAction() + ": " + currentCount + " new messages, with total " + receivedCount + " so far. Last group took: " + groupDuration + " millis which is: " + this.numberFormat.format(this.rate) + " messages per second. average: " + this.numberFormat.format(this.average);
        this.logger.log(this.lastLogMessage);
    }

    protected double messagesPerSecond(long messageCount, long duration) {
        return (double)messageCount * 1000.0 / (double)duration;
    }

    private final class ScheduledLogTask
    implements Runnable {
        private ScheduledLogTask() {
        }

        @Override
        public void run() {
            if (!ThroughputLogger.this.camelContext.getStatus().isStarted()) {
                LOG.trace("ThroughputLogger cannot start because CamelContext({}) has not been started yet", (Object)ThroughputLogger.this.camelContext.getName());
                return;
            }
            ThroughputLogger.this.createGroupIntervalLogMessage();
        }
    }
}

