/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.common;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Rule;
import org.wildfly.elytron.web.undertow.common.AbstractHttpServerMechanismTest;
import org.wildfly.elytron.web.undertow.common.UndertowServer;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.permission.PermissionVerifier;

public abstract class ExternalAuthenticationBase
extends AbstractHttpServerMechanismTest {
    @Rule
    public UndertowServer server = this.createUndertowServer();
    private AtomicInteger realmIdentityInvocationCount = new AtomicInteger(0);

    protected ExternalAuthenticationBase() throws Exception {
    }

    @Override
    protected String getMechanismName() {
        return "EXTERNAL";
    }

    @Override
    protected SecurityDomain doCreateSecurityDomain() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance("clear");
        HashMap<String, SimpleRealmEntry> passwordMap = new HashMap<String, SimpleRealmEntry>();
        passwordMap.put("remoteUser", new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(passwordFactory.generatePassword(new ClearPasswordSpec("doesnotmatter".toCharArray()))))));
        final SimpleMapBackedSecurityRealm delegate = new SimpleMapBackedSecurityRealm();
        delegate.setPasswordMap(passwordMap);
        SecurityRealm securityRealm = new SecurityRealm(){

            @Override
            public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
                ExternalAuthenticationBase.this.realmIdentityInvocationCount.incrementAndGet();
                return delegate.getRealmIdentity(principal);
            }

            @Override
            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec algorithmParameterSpec) throws RealmUnavailableException {
                return delegate.getCredentialAcquireSupport(credentialType, algorithmName, algorithmParameterSpec);
            }

            @Override
            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return delegate.getEvidenceVerifySupport(evidenceType, algorithmName);
            }
        };
        SecurityDomain.Builder builder = SecurityDomain.builder().setDefaultRealmName("TestRealm");
        builder.addRealm("TestRealm", securityRealm).build();
        builder.setPermissionMapper((principal, roles) -> PermissionVerifier.from(new LoginPermission()));
        return builder.build();
    }

    protected abstract UndertowServer createUndertowServer() throws Exception;
}

