/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server.servlet;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.SavedRequest;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.elytron.web.undertow.server.ScopeSessionListener;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpScopeNotification;
import org.wildfly.security.http.Scope;

class ElytronHttpServletExchange
extends ElytronHttpExchange {
    private static final Logger log = Logger.getLogger("org.wildfly.security.http.servlet");
    private final HttpServerExchange httpServerExchange;
    private final ScopeSessionListener scopeSessionListener;
    static Function<HttpServerExchange, HttpScope> APPLICATION_SCOPE_RESOLVER = ElytronHttpServletExchange::applicationScope;

    protected ElytronHttpServletExchange(HttpServerExchange httpServerExchange, ScopeSessionListener scopeSessionListener) {
        super(httpServerExchange);
        this.httpServerExchange = httpServerExchange;
        this.scopeSessionListener = scopeSessionListener;
    }

    @Override
    protected SessionManager getSessionManager() {
        ServletRequestContext servletRequestContext = this.httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return servletRequestContext.getDeployment().getSessionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getRequestParameters() {
        if (this.requestParameters == null) {
            ElytronHttpServletExchange elytronHttpServletExchange = this;
            synchronized (elytronHttpServletExchange) {
                HashMap<String, List<String>> requestParameters;
                ServletRequestContext servletRequestContext = this.httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                ServletRequest servletRequest = servletRequestContext.getServletRequest();
                if (servletRequest instanceof HttpServletRequest) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
                    Map<String, String[]> parameters = httpServletRequest.getParameterMap();
                    requestParameters = new HashMap<String, List<String>>(parameters.size());
                    for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                        requestParameters.put(entry.getKey(), Collections.unmodifiableList(Arrays.asList(entry.getValue())));
                    }
                } else {
                    return super.getRequestParameters();
                }
                this.requestParameters = Collections.unmodifiableMap(requestParameters);
            }
        }
        return this.requestParameters;
    }

    @Override
    protected SessionConfig getSessionConfig() {
        ServletRequestContext servletRequestContext = this.httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return servletRequestContext.getCurrentServletContext().getSessionConfig();
    }

    @Override
    public int forward(String path) {
        ServletRequestContext servletRequestContext = this.httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest req = servletRequestContext.getServletRequest();
        ServletResponse resp = servletRequestContext.getServletResponse();
        RequestDispatcher disp = req.getRequestDispatcher(path);
        if (disp == null) {
            return super.forward(path);
        }
        FormResponseWrapper respWrapper = this.httpServerExchange.getStatusCode() != 200 && resp instanceof HttpServletResponse ? new FormResponseWrapper((HttpServletResponse)resp) : null;
        try {
            disp.forward(req, respWrapper != null ? respWrapper : resp);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return respWrapper != null ? respWrapper.getStatus() : this.httpServerExchange.getStatusCode();
    }

    @Override
    public boolean suspendRequest() {
        SavedRequest.trySaveRequest(this.httpServerExchange);
        return true;
    }

    @Override
    public boolean resumeRequest() {
        ServletRequestContext servletRequestContext = this.httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpSessionImpl session = servletRequestContext.getCurrentServletContext().getSession(this.httpServerExchange, false);
        if (session != null) {
            SavedRequest.tryRestoreRequest(this.httpServerExchange, session);
        }
        return true;
    }

    @Override
    public HttpScope getScope(Scope scope) {
        switch (scope) {
            case APPLICATION: {
                return ElytronHttpServletExchange.applicationScope(this.httpServerExchange);
            }
            case EXCHANGE: {
                return ElytronHttpServletExchange.requestScope(this.httpServerExchange);
            }
            case SESSION: {
                return ElytronHttpServletExchange.sessionScope(this.httpServerExchange, this.scopeSessionListener, this.getSessionManager(), this.getSessionConfig());
            }
        }
        return super.getScope(scope);
    }

    private static HttpScope applicationScope(HttpServerExchange exchange) {
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (servletRequestContext != null) {
            final Deployment deployment = servletRequestContext.getDeployment();
            final ServletContextImpl servletContext = deployment.getServletContext();
            return new HttpScope(){

                @Override
                public String getID() {
                    return deployment.getDeploymentInfo().getDeploymentName();
                }

                @Override
                public boolean supportsAttachments() {
                    return true;
                }

                @Override
                public void setAttachment(String key, Object value) {
                    servletContext.setAttribute(key, value);
                }

                @Override
                public Object getAttachment(String key) {
                    return servletContext.getAttribute(key);
                }

                @Override
                public boolean supportsResources() {
                    return true;
                }

                @Override
                public InputStream getResource(String path) {
                    return servletContext.getResourceAsStream(path);
                }
            };
        }
        return null;
    }

    private static HttpScope requestScope(HttpServerExchange exchange) {
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (servletRequestContext != null) {
            final ServletRequest servletRequest = servletRequestContext.getServletRequest();
            return new HttpScope(){

                @Override
                public boolean supportsAttachments() {
                    return true;
                }

                @Override
                public void setAttachment(String key, Object value) {
                    servletRequest.setAttribute(key, value);
                }

                @Override
                public Object getAttachment(String key) {
                    return servletRequest.getAttribute(key);
                }
            };
        }
        return null;
    }

    private static HttpScope sessionScope(final HttpServerExchange exchange, final ScopeSessionListener listener, final SessionManager sessionManager, final SessionConfig sessionConfig) {
        final ServletRequestContext context = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return new HttpScope(){
            private HttpSession session;
            {
                this.session = context.getOriginalRequest().getSession(false);
            }

            @Override
            public String getID() {
                return this.exists() ? this.session.getId() : null;
            }

            @Override
            public boolean exists() {
                return this.session != null;
            }

            @Override
            public synchronized boolean create() {
                if (this.exists()) {
                    return false;
                }
                this.session = context.getOriginalRequest().getSession(true);
                return this.session != null;
            }

            @Override
            public boolean supportsAttachments() {
                return true;
            }

            @Override
            public void setAttachment(String key, Object value) {
                if (this.exists()) {
                    this.session.setAttribute(key, value);
                }
            }

            @Override
            public Object getAttachment(String key) {
                return this.exists() ? this.session.getAttribute(key) : null;
            }

            @Override
            public boolean supportsInvalidation() {
                return true;
            }

            @Override
            public boolean supportsChangeID() {
                return true;
            }

            @Override
            public boolean changeID() {
                if (this.exists()) {
                    Session session = sessionManager.getSession(exchange, sessionConfig);
                    session.changeSessionId(exchange, sessionConfig);
                    return true;
                }
                return false;
            }

            @Override
            public boolean invalidate() {
                if (this.exists()) {
                    try {
                        this.session.invalidate();
                        return true;
                    }
                    catch (IllegalStateException cause) {
                        log.debugf("Failed to invalidate session", (Object)cause);
                    }
                }
                return false;
            }

            @Override
            public boolean supportsNotifications() {
                return true;
            }

            @Override
            public void registerForNotification(Consumer<HttpScopeNotification> consumer) {
                if (this.exists()) {
                    listener.registerListener(this.session.getId(), consumer);
                }
            }
        };
    }

    private static class FormResponseWrapper
    extends HttpServletResponseWrapper {
        private int status = 200;

        private FormResponseWrapper(HttpServletResponse wrapped) {
            super(wrapped);
        }

        @Override
        public void setStatus(int sc) {
            this.status = sc;
        }

        @Override
        public int getStatus() {
            return this.status;
        }
    }
}

