/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.IdentityCredentialCallback;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.oidc.AuthChallenge;
import org.wildfly.security.http.oidc.AuthenticationError;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.LogoutError;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcAccount;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcClientContext;
import org.wildfly.security.http.oidc.OidcCookieTokenStore;
import org.wildfly.security.http.oidc.OidcPrincipal;
import org.wildfly.security.http.oidc.OidcSecurityContext;
import org.wildfly.security.http.oidc.OidcSessionTokenStore;
import org.wildfly.security.http.oidc.OidcTokenStore;
import org.wildfly.security.http.oidc.RefreshableOidcSecurityContext;

public class OidcHttpFacade {
    private final HttpServerRequest request;
    private final CallbackHandler callbackHandler;
    private final OidcTokenStore tokenStore;
    private final OidcClientContext oidcClientContext;
    private Consumer<HttpServerResponse> responseConsumer;
    private OidcAccount account;
    private SecurityIdentity securityIdentity;
    private boolean restored;
    private final Map<String, String> headers = new HashMap<String, String>();

    public OidcHttpFacade(HttpServerRequest request, OidcClientContext oidcClientContext, CallbackHandler handler) {
        this.request = request;
        this.oidcClientContext = oidcClientContext;
        this.callbackHandler = handler;
        this.tokenStore = this.createTokenStore();
        this.responseConsumer = response -> {};
    }

    void authenticationComplete(OidcAccount account, boolean storeToken) {
        this.securityIdentity = OidcHttpFacade.authorize(this.callbackHandler, account.getPrincipal());
        if (this.securityIdentity != null) {
            this.account = account;
            RefreshableOidcSecurityContext securityContext = account.getOidcSecurityContext();
            account.setCurrentRequestInfo(securityContext.getOidcClientConfiguration(), this.tokenStore);
            if (storeToken) {
                this.tokenStore.saveAccountInfo(account);
            }
        }
    }

    static final SecurityIdentity authorize(CallbackHandler callbackHandler, final Principal principal) {
        block4: {
            try {
                EvidenceVerifyCallback evidenceVerifyCallback = new EvidenceVerifyCallback(new Evidence(){

                    @Override
                    public Principal getPrincipal() {
                        return principal;
                    }
                });
                callbackHandler.handle(new Callback[]{evidenceVerifyCallback});
                if (!evidenceVerifyCallback.isVerified()) break block4;
                AuthorizeCallback authorizeCallback = new AuthorizeCallback(null, null);
                try {
                    callbackHandler.handle(new Callback[]{authorizeCallback});
                    authorizeCallback.isAuthorized();
                }
                catch (Exception e) {
                    throw new HttpAuthenticationException(e);
                }
                SecurityIdentityCallback securityIdentityCallback = new SecurityIdentityCallback();
                IdentityCredentialCallback credentialCallback = new IdentityCredentialCallback(new BearerTokenCredential(((OidcSecurityContext)((OidcPrincipal)OidcPrincipal.class.cast(principal)).getOidcSecurityContext()).getTokenString()), true);
                callbackHandler.handle(new Callback[]{credentialCallback, AuthenticationCompleteCallback.SUCCEEDED, securityIdentityCallback});
                return securityIdentityCallback.getSecurityIdentity();
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    void authenticationComplete() {
        if (this.securityIdentity != null) {
            HttpScope requestScope = this.request.getScope(Scope.EXCHANGE);
            RefreshableOidcSecurityContext securityContext = this.account.getOidcSecurityContext();
            requestScope.setAttachment(OidcSecurityContext.class.getName(), securityContext);
            this.request.authenticationComplete((HttpServerResponse response) -> {
                if (!this.restored) {
                    this.responseConsumer.accept(response);
                }
            }, () -> this.tokenStore.logout(true));
        }
    }

    void authenticationFailed() {
        this.request.authenticationFailed("Authentication Failed", response -> this.responseConsumer.accept(response));
    }

    void noAuthenticationInProgress() {
        this.request.noAuthenticationInProgress();
    }

    void noAuthenticationInProgress(AuthChallenge challenge) {
        if (challenge != null) {
            challenge.challenge(this);
        }
        this.request.noAuthenticationInProgress((HttpServerResponse response) -> this.responseConsumer.accept(response));
    }

    void authenticationInProgress() {
        this.request.authenticationInProgress(response -> this.responseConsumer.accept(response));
    }

    HttpScope getScope(Scope scope) {
        return this.request.getScope(scope);
    }

    HttpScope getScope(Scope scope, String id) {
        return this.request.getScope(scope, id);
    }

    Collection<String> getScopeIds(Scope scope) {
        return this.request.getScopeIds(scope);
    }

    OidcTokenStore getTokenStore() {
        return this.tokenStore;
    }

    OidcClientConfiguration getOidcClientConfiguration() {
        return this.oidcClientContext.resolveDeployment(this);
    }

    private OidcTokenStore createTokenStore() {
        OidcClientConfiguration deployment = this.getOidcClientConfiguration();
        if (Oidc.TokenStore.SESSION.equals((Object)deployment.getTokenStore())) {
            return new OidcSessionTokenStore(this);
        }
        return new OidcCookieTokenStore(this);
    }

    public Request getRequest() {
        return new Request(){
            private InputStream inputStream;

            @Override
            public String getMethod() {
                return OidcHttpFacade.this.request.getRequestMethod();
            }

            @Override
            public String getURI() {
                try {
                    return URLDecoder.decode(OidcHttpFacade.this.request.getRequestURI().toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw ElytronMessages.log.failedToDecodeRequestUri(e);
                }
            }

            @Override
            public String getRelativePath() {
                return OidcHttpFacade.this.request.getRequestPath();
            }

            @Override
            public boolean isSecure() {
                return OidcHttpFacade.this.request.getRequestURI().getScheme().equals("https");
            }

            @Override
            public String getFirstParam(String param) {
                return OidcHttpFacade.this.request.getFirstParameterValue(param);
            }

            @Override
            public String getQueryParamValue(String param) {
                URI requestURI = OidcHttpFacade.this.request.getRequestURI();
                String query = requestURI.getQuery();
                if (query != null) {
                    String[] parameters;
                    for (String parameter : parameters = query.split("&")) {
                        String[] keyValue = parameter.split("=", 2);
                        if (!keyValue[0].equals(param)) continue;
                        try {
                            return URLDecoder.decode(keyValue[1], "UTF-8");
                        }
                        catch (IOException e) {
                            throw ElytronMessages.log.failedToDecodeRequestUri(e);
                        }
                    }
                }
                return null;
            }

            @Override
            public Cookie getCookie(String cookieName) {
                List<HttpServerCookie> cookies = OidcHttpFacade.this.request.getCookies();
                if (cookies != null) {
                    for (HttpServerCookie cookie : cookies) {
                        if (!cookie.getName().equals(cookieName)) continue;
                        return new Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
                    }
                }
                return null;
            }

            @Override
            public String getHeader(String name) {
                return OidcHttpFacade.this.request.getFirstRequestHeaderValue(name);
            }

            @Override
            public List<String> getHeaders(String name) {
                return OidcHttpFacade.this.request.getRequestHeaderValues(name);
            }

            @Override
            public InputStream getInputStream() {
                return this.getInputStream(false);
            }

            @Override
            public InputStream getInputStream(boolean buffered) {
                if (this.inputStream != null) {
                    return this.inputStream;
                }
                if (buffered) {
                    this.inputStream = new BufferedInputStream(OidcHttpFacade.this.request.getInputStream());
                    Supplier<InputStream> inputStreamSupplier = () -> {
                        this.inputStream.mark(0);
                        return new ServletInputStream(){

                            @Override
                            public int read() throws IOException {
                                return inputStream.read();
                            }

                            @Override
                            public boolean isFinished() {
                                try {
                                    return inputStream.available() == 0;
                                }
                                catch (IOException e) {
                                    return true;
                                }
                            }

                            @Override
                            public boolean isReady() {
                                return true;
                            }

                            @Override
                            public void setReadListener(ReadListener listener) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    };
                    OidcHttpFacade.this.request.setRequestInputStreamSupplier(inputStreamSupplier);
                    return this.inputStream;
                }
                return OidcHttpFacade.this.request.getInputStream();
            }

            @Override
            public String getRemoteAddr() {
                InetSocketAddress sourceAddress = OidcHttpFacade.this.request.getSourceAddress();
                if (sourceAddress == null) {
                    return "";
                }
                InetAddress address = sourceAddress.getAddress();
                if (address == null) {
                    return sourceAddress.getHostString();
                }
                return address.getHostAddress();
            }

            @Override
            public void setError(AuthenticationError error) {
                OidcHttpFacade.this.request.getScope(Scope.EXCHANGE).setAttachment(AuthenticationError.class.getName(), error);
            }

            @Override
            public void setError(LogoutError error) {
                OidcHttpFacade.this.request.getScope(Scope.EXCHANGE).setAttachment(LogoutError.class.getName(), error);
            }
        };
    }

    public Response getResponse() {
        return new Response(){

            @Override
            public void setStatus(int status) {
                if (status < 200 || status > 300) {
                    OidcHttpFacade.this.responseConsumer = OidcHttpFacade.this.responseConsumer.andThen(response -> response.setStatusCode(status));
                }
            }

            @Override
            public void addHeader(final String name, final String value) {
                OidcHttpFacade.this.headers.put(name, value);
                OidcHttpFacade.this.responseConsumer = OidcHttpFacade.this.responseConsumer.andThen(new Consumer<HttpServerResponse>(){

                    @Override
                    public void accept(HttpServerResponse response) {
                        String latestValue = (String)OidcHttpFacade.this.headers.get(name);
                        if (latestValue.equals(value)) {
                            response.addResponseHeader(name, latestValue);
                        }
                    }
                });
            }

            @Override
            public void setHeader(String name, String value) {
                this.addHeader(name, value);
            }

            @Override
            public void resetCookie(String name, String path) {
                OidcHttpFacade.this.responseConsumer = OidcHttpFacade.this.responseConsumer.andThen(response -> this.setCookie(name, "", path, null, 0, false, false, (HttpServerResponse)response));
            }

            @Override
            public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
                OidcHttpFacade.this.responseConsumer = OidcHttpFacade.this.responseConsumer.andThen(response -> this.setCookie(name, value, path, domain, maxAge, secure, httpOnly, (HttpServerResponse)response));
            }

            private void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly, HttpServerResponse response) {
                response.setResponseCookie(HttpServerCookie.getInstance(name, value, domain, maxAge, path, secure, 0, httpOnly));
            }

            @Override
            public OutputStream getOutputStream() {
                final ByteArrayOutputStream stream = new ByteArrayOutputStream();
                OidcHttpFacade.this.responseConsumer = OidcHttpFacade.this.responseConsumer.andThen(new Consumer<HttpServerResponse>(){

                    @Override
                    public void accept(HttpServerResponse httpServerResponse) {
                        try {
                            httpServerResponse.getOutputStream().write(stream.toByteArray());
                        }
                        catch (IOException e) {
                            throw ElytronMessages.log.failedToWriteToResponseOutputStream(e);
                        }
                    }
                });
                return stream;
            }

            @Override
            public void sendError(int code) {
                this.setStatus(code);
            }

            @Override
            public void sendError(int code, String message) {
                OidcHttpFacade.this.responseConsumer = OidcHttpFacade.this.responseConsumer.andThen(response -> {
                    response.setStatusCode(code);
                    response.addResponseHeader("Content-Type", "text/html");
                    try {
                        response.getOutputStream().write(message.getBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }

            @Override
            public void end() {
            }
        };
    }

    public Certificate[] getCertificateChain() {
        return this.request.getPeerCertificates();
    }

    public OidcSecurityContext getSecurityContext() {
        if (this.account == null) {
            return null;
        }
        return this.account.getOidcSecurityContext();
    }

    public boolean restoreRequest() {
        this.restored = this.request.resumeRequest();
        return this.restored;
    }

    public void suspendRequest() {
        this.responseConsumer = this.responseConsumer.andThen(httpServerResponse -> this.request.suspendRequest());
    }

    public boolean isAuthorized() {
        return this.securityIdentity != null;
    }

    public class Cookie {
        protected String name;
        protected String value;
        protected int version;
        protected String domain;
        protected String path;

        public Cookie(String name, String value, int version, String domain, String path) {
            this.name = name;
            this.value = value;
            this.version = version;
            this.domain = domain;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getVersion() {
            return this.version;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static interface Response {
        public void setStatus(int var1);

        public void addHeader(String var1, String var2);

        public void setHeader(String var1, String var2);

        public void resetCookie(String var1, String var2);

        public void setCookie(String var1, String var2, String var3, String var4, int var5, boolean var6, boolean var7);

        public OutputStream getOutputStream();

        public void sendError(int var1);

        public void sendError(int var1, String var2);

        public void end();
    }

    public static interface Request {
        public String getMethod();

        public String getURI();

        public String getRelativePath();

        public boolean isSecure();

        public String getFirstParam(String var1);

        public String getQueryParamValue(String var1);

        public Cookie getCookie(String var1);

        public String getHeader(String var1);

        public List<String> getHeaders(String var1);

        public InputStream getInputStream();

        public InputStream getInputStream(boolean var1);

        public String getRemoteAddr();

        public void setError(AuthenticationError var1);

        public void setError(LogoutError var1);
    }
}

