/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gssapi;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.IdentityCredentialCallback;
import org.wildfly.security.auth.callback.ServerCredentialCallback;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism.gssapi.GSSCredentialSecurityFactory;
import org.wildfly.security.sasl.gssapi.AbstractGssapiMechanism;

final class GssapiServer
extends AbstractGssapiMechanism
implements SaslServer {
    private static final int ACCEPTOR_STATE = 1;
    private static final int SECURITY_LAYER_ADVERTISER = 2;
    private static final int SECURITY_LAYER_RECEIVER = 3;
    private String authorizationId;
    private String boundServerName;
    private byte offeredSecurityLayer;

    GssapiServer(String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) throws SaslException {
        super("GSSAPI", protocol, serverName, props, callbackHandler);
        GSSManager manager = GSSManager.getInstance();
        if (props.containsKey("wildfly.sasl.gssapi.server.create-name-gss-init") && Boolean.parseBoolean((String)props.get("wildfly.sasl.gssapi.server.create-name-gss-init"))) {
            try {
                manager.createName("dummy", GSSName.NT_USER_NAME, GSSCredentialSecurityFactory.KERBEROS_V5);
                ElytronMessages.saslGssapi.trace("createName workaround for native GSS initialization applied");
            }
            catch (GSSException e1) {
                ElytronMessages.saslGssapi.trace("Exception while applying createName workaround for native GSS initialization", e1);
            }
        }
        GSSContext gssContext = null;
        GSSCredential ourCredential = null;
        ServerCredentialCallback gssCredentialCallback = new ServerCredentialCallback(GSSKerberosCredential.class);
        try {
            ElytronMessages.saslGssapi.trace("Obtaining GSSCredential for the service from callback handler...");
            callbackHandler.handle(new Callback[]{gssCredentialCallback});
            ourCredential = gssCredentialCallback.applyToCredential(GSSKerberosCredential.class, GSSKerberosCredential::getGssCredential);
        }
        catch (IOException e) {
            throw ElytronMessages.saslGssapi.mechCallbackHandlerFailedForUnknownReason(e).toSaslException();
        }
        catch (UnsupportedCallbackException e) {
            ElytronMessages.saslGssapi.trace("Unable to obtain GSSCredential from CallbackHandler", e);
        }
        try {
            if (ourCredential == null) {
                GSSName ourName;
                if (serverName != null) {
                    String localName = protocol + "@" + serverName;
                    ElytronMessages.saslGssapi.tracef("Our name is '%s'", (Object)localName);
                    ourName = manager.createName(localName, GSSName.NT_HOSTBASED_SERVICE, GSSCredentialSecurityFactory.KERBEROS_V5);
                } else {
                    ElytronMessages.saslGssapi.tracef("Our name is unbound", new Object[0]);
                    ourName = null;
                }
                ourCredential = manager.createCredential(ourName, Integer.MAX_VALUE, GSSCredentialSecurityFactory.KERBEROS_V5, 2);
            }
            gssContext = manager.createContext(ourCredential);
        }
        catch (GSSException e) {
            throw ElytronMessages.saslGssapi.mechUnableToCreateGssContext(e).toSaslException();
        }
        this.gssContext = gssContext;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public String getAuthorizationID() {
        this.assertComplete();
        return this.authorizationId;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.evaluateMessage(response);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                assert (!this.gssContext.isEstablished());
                try {
                    byte[] response = this.gssContext.acceptSecContext(message, 0, message.length);
                    if (this.gssContext.isEstablished()) {
                        Oid actualMech = this.gssContext.getMech();
                        ElytronMessages.saslGssapi.tracef("Negotiated mechanism %s", (Object)actualMech);
                        if (!GSSCredentialSecurityFactory.KERBEROS_V5.equals(actualMech)) {
                            throw ElytronMessages.saslGssapi.mechNegotiatedMechanismWasNotKerberosV5().toSaslException();
                        }
                        this.setNegotiationState(2);
                        if (response == null || response.length == 0) {
                            ElytronMessages.saslGssapi.trace("No response so triggering next state immediately.");
                            return this.evaluateMessage(null);
                        }
                    } else {
                        ElytronMessages.saslGssapi.trace("GSSContext not established, expecting subsequent exchange.");
                    }
                    return response;
                }
                catch (GSSException e) {
                    throw ElytronMessages.saslGssapi.mechUnableToAcceptClientMessage(e).toSaslException();
                }
            }
            case 2: {
                if (message != null && message.length > 0) {
                    throw ElytronMessages.saslGssapi.mechInitialChallengeMustBeEmpty().toSaslException();
                }
                byte[] response = new byte[4];
                byte supportedSecurityLayers = 0;
                boolean offeringSecurityLayer = false;
                block24: for (AbstractGssapiMechanism.QOP current : this.orderedQops) {
                    switch (current) {
                        case AUTH_INT: {
                            if (this.gssContext.getIntegState()) {
                                supportedSecurityLayers = (byte)(supportedSecurityLayers | current.getValue());
                                offeringSecurityLayer = true;
                                ElytronMessages.saslGssapi.trace("Offering AUTH_INT");
                                continue block24;
                            }
                            ElytronMessages.saslGssapi.trace("No integrity protection so unable to offer AUTH_INT");
                            continue block24;
                        }
                        case AUTH_CONF: {
                            if (this.gssContext.getConfState()) {
                                supportedSecurityLayers = (byte)(supportedSecurityLayers | current.getValue());
                                offeringSecurityLayer = true;
                                ElytronMessages.saslGssapi.trace("Offering AUTH_CONF");
                                continue block24;
                            }
                            ElytronMessages.saslGssapi.trace("No confidentiality available so unable to offer AUTH_CONF");
                            continue block24;
                        }
                        default: {
                            supportedSecurityLayers = (byte)(supportedSecurityLayers | current.getValue());
                        }
                    }
                }
                if (supportedSecurityLayers == 0) {
                    throw ElytronMessages.saslGssapi.mechInsufficientQopsAvailable().toSaslException();
                }
                response[0] = supportedSecurityLayers;
                try {
                    byte[] length;
                    if (offeringSecurityLayer) {
                        ElytronMessages.saslGssapi.tracef("Our max buffer size %d", this.configuredMaxReceiveBuffer);
                        length = this.intToNetworkOrderBytes(this.configuredMaxReceiveBuffer);
                    } else {
                        ElytronMessages.saslGssapi.trace("Not offering a security layer so zero length.");
                        length = new byte[]{0, 0, 0};
                    }
                    System.arraycopy(length, 0, response, 1, 3);
                    MessageProp msgProp = new MessageProp(0, false);
                    response = this.gssContext.wrap(response, 0, 4, msgProp);
                }
                catch (GSSException e) {
                    throw ElytronMessages.saslGssapi.mechUnableToGenerateChallenge(e).toSaslException();
                }
                ElytronMessages.saslGssapi.trace("Transitioning to receive chosen security layer from client");
                this.offeredSecurityLayer = supportedSecurityLayers;
                this.setNegotiationState(3);
                return response;
            }
            case 3: {
                String authenticationId;
                byte[] unwrapped;
                MessageProp msgProp = new MessageProp(0, false);
                try {
                    unwrapped = this.gssContext.unwrap(message, 0, message.length, msgProp);
                }
                catch (GSSException e) {
                    throw ElytronMessages.saslGssapi.mechUnableToUnwrapMessage(e).toSaslException();
                }
                if (unwrapped.length < 4) {
                    throw ElytronMessages.saslGssapi.mechInvalidMessageOnUnwrapping(unwrapped.length).toSaslException();
                }
                if ((this.offeredSecurityLayer & unwrapped[0]) == 0) {
                    throw ElytronMessages.saslGssapi.mechSelectedUnofferedQop().toSaslException();
                }
                AbstractGssapiMechanism.QOP selectedQop = AbstractGssapiMechanism.QOP.mapFromValue(unwrapped[0]);
                assert (selectedQop != null);
                this.maxBuffer = this.networkOrderBytesToInt(unwrapped, 1, 3);
                ElytronMessages.saslGssapi.tracef("Client selected security layer %s, with maxBuffer of %d", (Object)selectedQop, (Object)this.maxBuffer);
                if (!this.relaxComplianceChecks && selectedQop == AbstractGssapiMechanism.QOP.AUTH && this.maxBuffer != 0) {
                    throw ElytronMessages.saslGssapi.mechNoSecurityLayerButLengthReceived().toSaslException();
                }
                try {
                    this.maxBuffer = this.gssContext.getWrapSizeLimit(0, selectedQop == AbstractGssapiMechanism.QOP.AUTH_CONF, this.maxBuffer);
                }
                catch (GSSException e) {
                    throw ElytronMessages.saslGssapi.mechUnableToGetMaximumSizeOfMessage(e).toSaslException();
                }
                this.selectedQop = selectedQop;
                try {
                    String targetName = this.gssContext.getTargName().toString();
                    String[] targetNameParts = targetName.split("[/@]");
                    this.boundServerName = targetNameParts.length > 1 ? targetNameParts[1] : targetName;
                }
                catch (GSSException e) {
                    throw ElytronMessages.saslGssapi.mechUnableToDetermineBoundServerName(e).toSaslException();
                }
                try {
                    authenticationId = this.gssContext.getSrcName().toString();
                }
                catch (GSSException e) {
                    throw ElytronMessages.saslGssapi.mechUnableToDeterminePeerName(e).toSaslException();
                }
                String authorizationId = unwrapped.length > 4 ? new String(unwrapped, 4, unwrapped.length - 4, StandardCharsets.UTF_8) : authenticationId;
                ElytronMessages.saslGssapi.tracef("Authentication ID=%s,  Authorization ID=%s", (Object)authenticationId, (Object)authorizationId);
                AuthorizeCallback cb = new AuthorizeCallback(authenticationId, authorizationId);
                this.handleCallbacks(cb);
                if (!cb.isAuthorized()) {
                    throw ElytronMessages.saslGssapi.mechAuthorizationFailed(authenticationId, authorizationId).toSaslException();
                }
                this.authorizationId = authorizationId;
                if (selectedQop != AbstractGssapiMechanism.QOP.AUTH) {
                    ElytronMessages.saslGssapi.trace("Setting message wrapper.");
                    this.setWrapper(new AbstractGssapiMechanism.GssapiWrapper(this, selectedQop == AbstractGssapiMechanism.QOP.AUTH_CONF));
                }
                try {
                    GSSCredential gssCredential = this.gssContext.getDelegCred();
                    if (gssCredential != null) {
                        this.tryHandleCallbacks(new IdentityCredentialCallback(new GSSKerberosCredential(gssCredential), true));
                    } else {
                        ElytronMessages.saslGssapi.trace("No GSSCredential delegated during authentication.");
                    }
                }
                catch (UnsupportedCallbackException | GSSException gssCredential) {
                }
                catch (SaslException e) {
                    throw e;
                }
                ElytronMessages.saslGssapi.trace("Negotiation complete.");
                this.negotiationComplete();
                return null;
            }
        }
        throw Assert.impossibleSwitchCase(state);
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        this.assertComplete();
        if ("javax.security.sasl.bound.server.name".equals(propName)) {
            return this.boundServerName;
        }
        return super.getNegotiatedProperty(propName);
    }
}

