/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;

public class InboundBuffer<E> {
    public static final Object END_SENTINEL = new Object();
    private final ContextInternal context;
    private ArrayDeque<E> pending;
    private final long highWaterMark;
    private long demand;
    private Handler<E> handler;
    private boolean overflow;
    private Handler<Void> drainHandler;
    private Handler<Void> emptyHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean emitting;

    public InboundBuffer(Context context) {
        this(context, 16L);
    }

    public InboundBuffer(Context context, long highWaterMark) {
        this(context, highWaterMark, Long.MAX_VALUE, null, null);
    }

    public static <E> InboundBuffer<E> createPaused(Context context, long highWaterMark, Handler<Void> drainHandler, Handler<E> handler) {
        Objects.requireNonNull(drainHandler);
        Objects.requireNonNull(handler);
        return new InboundBuffer<E>(context, highWaterMark, 0L, drainHandler, handler);
    }

    public static <E> InboundBuffer<E> createAndFetch(Context context, long highWaterMark, long demand, Handler<Void> drainHandler, Handler<E> handler) {
        Objects.requireNonNull(drainHandler);
        Objects.requireNonNull(handler);
        InboundBuffer.checkPositiveAmount(demand);
        InboundBuffer inboundBuffer = new InboundBuffer(context, highWaterMark, Long.MAX_VALUE, drainHandler, handler);
        if (super.emit(demand)) {
            super.asyncDrain();
            inboundBuffer.context.runOnContext(v -> inboundBuffer.drain());
        }
        return inboundBuffer;
    }

    private InboundBuffer(Context context, long highWaterMark, long demand, Handler<Void> drainHandler, Handler<E> handler) {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        if (highWaterMark < 0L) {
            throw new IllegalArgumentException("highWaterMark " + highWaterMark + " >= 0");
        }
        this.context = (ContextInternal)context;
        this.highWaterMark = highWaterMark;
        this.demand = demand;
        this.pending = null;
        this.drainHandler = drainHandler;
        this.handler = handler;
    }

    private void checkThread() {
        if (!this.context.inThread()) {
            throw new IllegalStateException("This operation must be called from a Vert.x thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(E element) {
        Handler<E> handler;
        this.checkThread();
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            if (this.demand == 0L || this.emitting) {
                if (this.pending == null) {
                    this.pending = new ArrayDeque(1);
                }
                this.pending.add(element);
                return this.checkWritable();
            }
            if (this.demand != Long.MAX_VALUE) {
                --this.demand;
            }
            this.emitting = true;
            handler = this.handler;
        }
        this.handleEvent(handler, element);
        return this.emitPending();
    }

    private boolean checkWritable() {
        if (this.demand == Long.MAX_VALUE) {
            return true;
        }
        int size = this.pending == null ? 0 : this.pending.size();
        long actual = (long)size - this.demand;
        boolean writable = actual < this.highWaterMark;
        this.overflow |= !writable;
        return writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Iterable<E> elements) {
        this.checkThread();
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            if (this.pending == null) {
                int requiredCapacity = elements instanceof Collection ? ((Collection)elements).size() : 1;
                this.pending = new ArrayDeque(requiredCapacity);
            }
            for (E element : elements) {
                this.pending.add(element);
            }
            if (this.demand == 0L || this.emitting) {
                return this.checkWritable();
            }
            this.emitting = true;
        }
        return this.emitPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean emitPending() {
        while (true) {
            Handler<E> h2;
            E element;
            InboundBuffer inboundBuffer = this;
            synchronized (inboundBuffer) {
                int size = this.size();
                if (this.demand == 0L) {
                    this.emitting = false;
                    boolean writable = (long)size < this.highWaterMark;
                    this.overflow |= !writable;
                    return writable;
                }
                if (size == 0) {
                    this.emitting = false;
                    return true;
                }
                if (this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                assert (this.pending != null);
                element = this.pending.poll();
                h2 = this.handler;
            }
            this.handleEvent(h2, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        Handler<Void> emptyHandler;
        Handler<Void> drainHandler;
        int emitted = 0;
        while (true) {
            Handler<E> handler;
            E element;
            InboundBuffer inboundBuffer = this;
            synchronized (inboundBuffer) {
                int size = this.size();
                if (size == 0) {
                    this.emitting = false;
                    if (this.overflow) {
                        this.overflow = false;
                        drainHandler = this.drainHandler;
                    } else {
                        drainHandler = null;
                    }
                    emptyHandler = emitted > 0 ? this.emptyHandler : null;
                    break;
                }
                if (this.demand == 0L) {
                    this.emitting = false;
                    return;
                }
                ++emitted;
                if (this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                assert (this.pending != null);
                element = this.pending.poll();
                handler = this.handler;
            }
            this.handleEvent(handler, element);
        }
        if (drainHandler != null) {
            this.handleEvent(drainHandler, null);
        }
        if (emptyHandler != null) {
            this.handleEvent(emptyHandler, null);
        }
    }

    private <T> void handleEvent(Handler<T> handler, T element) {
        if (handler != null) {
            try {
                handler.handle(element);
            }
            catch (Throwable t2) {
                this.handleException(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Throwable err) {
        Handler<Throwable> handler;
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            handler = this.exceptionHandler;
            if (handler == null) {
                return;
            }
        }
        handler.handle(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetch(long amount) {
        InboundBuffer.checkPositiveAmount(amount);
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            if (!this.emit(amount)) {
                return false;
            }
        }
        this.asyncDrain();
        return true;
    }

    private void asyncDrain() {
        this.context.runOnContext(v -> this.drain());
    }

    private boolean emit(long amount) {
        assert (amount >= 0L);
        this.demand += amount;
        if (this.demand < 0L) {
            this.demand = Long.MAX_VALUE;
        }
        if (this.emitting || this.isEmpty() && !this.overflow) {
            return false;
        }
        this.emitting = true;
        return true;
    }

    private static void checkPositiveAmount(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E read() {
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            if (this.isEmpty()) {
                return null;
            }
            return this.pending.poll();
        }
    }

    public synchronized InboundBuffer<E> clear() {
        if (this.isEmpty()) {
            return this;
        }
        this.pending.clear();
        return this;
    }

    public synchronized InboundBuffer<E> pause() {
        this.demand = 0L;
        return this;
    }

    public boolean resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    public synchronized InboundBuffer<E> handler(Handler<E> handler) {
        this.handler = handler;
        return this;
    }

    public synchronized InboundBuffer<E> drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    public synchronized InboundBuffer<E> emptyHandler(Handler<Void> handler) {
        this.emptyHandler = handler;
        return this;
    }

    public synchronized InboundBuffer<E> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized boolean isEmpty() {
        if (this.pending == null) {
            return true;
        }
        return this.pending.isEmpty();
    }

    public synchronized boolean isWritable() {
        return (long)this.size() < this.highWaterMark;
    }

    public synchronized boolean isPaused() {
        return this.demand == 0L;
    }

    public synchronized int size() {
        return this.pending == null ? 0 : this.pending.size();
    }
}

